/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.CheckedRunnable;
import com.github.tonivade.purefun.Consumer1;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Recoverable;
import com.github.tonivade.purefun.Unit;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.effect.EIO;
import com.github.tonivade.purefun.effect.ZIO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.MonadDefer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;

@HigherKind
public final class UIO<T>
implements Recoverable,
Higher1<\u00b5, T> {
    private final ZIO<Nothing, Nothing, T> value;

    UIO(ZIO<Nothing, Nothing, T> value) {
        this.value = Objects.requireNonNull(value);
    }

    public T unsafeRunSync() {
        return (T)this.value.provide(Nothing.nothing()).get();
    }

    public Try<T> safeRunSync() {
        return Try.of(this::unsafeRunSync);
    }

    public <R, E> ZIO<R, E, T> toZIO() {
        return this.value;
    }

    public <E> EIO<E, T> toEIO() {
        return new EIO<Nothing, T>(this.value);
    }

    public Future<T> toFuture() {
        return this.value.toFuture(Nothing.nothing()).map(Either::get);
    }

    public void async(Executor executor, Consumer1<Try<T>> callback) {
        this.value.provideAsync(executor, Nothing.nothing(), result -> callback.accept((Object)result.map(Either::get)));
    }

    public void async(Consumer1<Try<T>> callback) {
        this.async(Future.DEFAULT_EXECUTOR, callback);
    }

    public <F extends Kind> Higher1<F, T> foldMap(MonadDefer<F> monad) {
        return monad.map(this.value.foldMap(Nothing.nothing(), monad), Either::get);
    }

    public <B> UIO<B> map(Function1<T, B> map) {
        return new UIO<B>(this.value.map(map));
    }

    public <B> UIO<B> flatMap(Function1<T, UIO<B>> map) {
        return new UIO(this.value.flatMap(x -> ((UIO)map.apply((Object)x)).value));
    }

    public <B> UIO<B> andThen(UIO<B> next) {
        return new UIO<T>(this.value.andThen(next.value));
    }

    public UIO<T> recover(Function1<Throwable, T> mapError) {
        return this.redeem(mapError, Function1.identity());
    }

    public <X extends Throwable> UIO<T> recoverWith(Class<X> type, Function1<X, T> function) {
        return this.recover(cause -> {
            if (type.isAssignableFrom(cause.getClass())) {
                return function.apply(cause);
            }
            return this.sneakyThrow((Throwable)cause);
        });
    }

    public <B> UIO<B> redeem(Function1<Throwable, B> mapError, Function1<T, B> map) {
        return this.redeemWith(mapError.andThen(UIO::pure), map.andThen(UIO::pure));
    }

    public <B> UIO<B> redeemWith(Function1<Throwable, UIO<B>> mapError, Function1<T, UIO<B>> map) {
        return new UIO(ZIO.redeem(this.value).foldM(error -> ((UIO)mapError.apply((Object)error)).value, x -> ((UIO)map.apply((Object)x)).value));
    }

    public UIO<T> repeat() {
        return this.repeat(1);
    }

    public UIO<T> repeat(int times) {
        return this.repeat(UIO.unit(), times);
    }

    public UIO<T> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    public UIO<T> repeat(Duration delay, int times) {
        return this.repeat(UIO.sleep(delay), times);
    }

    public UIO<T> retry() {
        return this.retry(1);
    }

    public UIO<T> retry(int maxRetries) {
        return this.retry(UIO.unit(), maxRetries);
    }

    public UIO<T> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    public UIO<T> retry(Duration delay, int maxRetries) {
        return this.retry(UIO.sleep(delay), maxRetries);
    }

    private UIO<T> repeat(UIO<Unit> pause, int times) {
        return this.redeemWith(UIO::raiseError, value -> {
            if (times > 0) {
                return pause.andThen(this.repeat(pause, times - 1));
            }
            return UIO.pure(value);
        });
    }

    private UIO<T> retry(UIO<Unit> pause, int maxRetries) {
        return this.redeemWith(error -> {
            if (maxRetries > 0) {
                return pause.andThen(this.retry(pause.repeat(), maxRetries - 1));
            }
            return UIO.raiseError(error);
        }, UIO::pure);
    }

    public static <A, B, C> UIO<C> map2(UIO<A> za, UIO<B> zb, Function2<A, B, C> mapper) {
        return new UIO<C>(ZIO.map2(za.value, zb.value, mapper));
    }

    public static UIO<Unit> sleep(Duration delay) {
        return UIO.exec(() -> Thread.sleep(delay.toMillis()));
    }

    public static UIO<Unit> exec(CheckedRunnable task) {
        return UIO.fold(ZIO.exec(task));
    }

    public static <A> UIO<A> pure(A value) {
        return new UIO<A>(ZIO.pure(value));
    }

    public static <A> UIO<A> raiseError(Throwable throwable) {
        return new UIO(ZIO.fromEither(() -> {
            throw throwable;
        }));
    }

    public static <A> UIO<A> defer(Producer<UIO<A>> lazy) {
        return new UIO(ZIO.defer(() -> ((UIO)lazy.get()).value));
    }

    public static <A> UIO<A> task(Producer<A> task) {
        return UIO.fold(ZIO.task(task));
    }

    public static <A extends AutoCloseable, B> UIO<B> bracket(UIO<A> acquire, Function1<A, UIO<B>> use) {
        return UIO.fold(ZIO.bracket(ZIO.redeem(acquire.value), resource -> ZIO.redeem(((UIO)use.apply((Object)resource)).value)));
    }

    public static <A, B> UIO<B> bracket(UIO<A> acquire, Function1<A, UIO<B>> use, Consumer1<A> release) {
        return UIO.fold(ZIO.bracket(ZIO.redeem(acquire.value), resource -> ZIO.redeem(((UIO)use.apply((Object)resource)).value), release));
    }

    public static UIO<Unit> unit() {
        return new UIO<Unit>(ZIO.unit());
    }

    private static <A> UIO<A> fold(ZIO<Nothing, Throwable, A> zio) {
        return new UIO(zio.foldM(error -> UIO.raiseError((Throwable)error).value, value -> UIO.pure(value).value));
    }

    public static <T> UIO<T> narrowK(Higher1<\u00b5, T> hkt) {
        return (UIO)hkt;
    }

    public static final class \u00b5
    implements Kind {
    }
}

