/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.CheckedRunnable;
import com.github.tonivade.purefun.Consumer1;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Higher2;
import com.github.tonivade.purefun.Higher3;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Sealed;
import com.github.tonivade.purefun.Unit;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.ZIOModule;
import com.github.tonivade.purefun.effect.ZIOResource;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.MonadDefer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;

@Sealed
@HigherKind
public interface ZIO<R, E, A>
extends Higher3<\u00b5, R, E, A> {
    public Either<E, A> provide(R var1);

    default public Future<Either<E, A>> toFuture(R env) {
        return this.toFuture(Future.DEFAULT_EXECUTOR, env);
    }

    default public Future<Either<E, A>> toFuture(Executor executor, R env) {
        return Future.async((Executor)executor, () -> this.provide(env));
    }

    default public void provideAsync(R env, Consumer1<Try<Either<E, A>>> callback) {
        this.provideAsync(Future.DEFAULT_EXECUTOR, env, callback);
    }

    default public void provideAsync(Executor executor, R env, Consumer1<Try<Either<E, A>>> callback) {
        this.toFuture(executor, env).onComplete(callback);
    }

    public <F extends Kind> Higher1<F, Either<E, A>> foldMap(R var1, MonadDefer<F> var2);

    default public ZIO<R, A, E> swap() {
        return new Swap(this);
    }

    default public <B> ZIO<R, E, B> map(Function1<A, B> map) {
        return this.flatMap(map.andThen(ZIO::pure));
    }

    default public <B> ZIO<R, B, A> mapError(Function1<E, B> map) {
        return this.flatMapError(map.andThen(ZIO::raiseError));
    }

    default public <B, F> ZIO<R, F, B> bimap(Function1<E, F> mapError, Function1<A, B> map) {
        return this.biflatMap(mapError.andThen(ZIO::raiseError), map.andThen(ZIO::pure));
    }

    default public <B> ZIO<R, E, B> flatMap(Function1<A, ZIO<R, E, B>> map) {
        return this.biflatMap(ZIO::raiseError, map);
    }

    default public <F> ZIO<R, F, A> flatMapError(Function1<E, ZIO<R, F, A>> map) {
        return this.biflatMap(map, ZIO::pure);
    }

    default public <F, B> ZIO<R, F, B> biflatMap(Function1<E, ZIO<R, F, B>> left, Function1<A, ZIO<R, F, B>> right) {
        return new FlatMapped<R, E, A, F, B>(Producer.cons((Object)this), left, right);
    }

    default public <B> ZIO<R, E, B> andThen(ZIO<R, E, B> next) {
        return this.flatMap(ignore -> next);
    }

    default public <F, B> ZIO<R, F, B> foldM(Function1<E, ZIO<R, F, B>> mapError, Function1<A, ZIO<R, F, B>> map) {
        return new FoldM<R, E, A, F, B>(this, mapError, map);
    }

    default public <B> ZIO<R, Nothing, B> fold(Function1<E, B> mapError, Function1<A, B> map) {
        return this.foldM(mapError.andThen(ZIO::pure), map.andThen(ZIO::pure));
    }

    default public ZIO<R, Nothing, A> recover(Function1<E, A> mapError) {
        return this.fold(mapError, Function1.identity());
    }

    default public ZIO<R, E, A> orElse(Producer<ZIO<R, E, A>> other) {
        return this.foldM(other.asFunction(), Function1.cons((Object)this));
    }

    default public ZIO<R, E, A> repeat() {
        return this.repeat(1);
    }

    default public ZIO<R, E, A> repeat(int times) {
        return ZIOModule.repeat(this, UIO.unit(), times);
    }

    default public ZIO<R, E, A> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    default public ZIO<R, E, A> repeat(Duration delay, int times) {
        return ZIOModule.repeat(this, UIO.sleep(delay), times);
    }

    default public ZIO<R, E, A> retry() {
        return this.retry(1);
    }

    default public ZIO<R, E, A> retry(int maxRetries) {
        return ZIOModule.retry(this, UIO.unit(), maxRetries);
    }

    default public ZIO<R, E, A> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    default public ZIO<R, E, A> retry(Duration delay, int maxRetries) {
        return ZIOModule.retry(this, UIO.sleep(delay), maxRetries);
    }

    public ZIOModule getModule();

    public static <R, E, A> ZIO<R, E, A> accessM(Function1<R, ZIO<R, E, A>> map) {
        return new AccessM<R, E, A>(map);
    }

    public static <R, A> ZIO<R, Nothing, A> access(Function1<R, A> map) {
        return ZIO.accessM(map.andThen(ZIO::pure));
    }

    public static <R> ZIO<R, Nothing, R> env() {
        return ZIO.access(Function1.identity());
    }

    public static <R, E, A, B, C> ZIO<R, E, C> map2(ZIO<R, E, A> za, ZIO<R, E, B> zb, Function2<A, B, C> mapper) {
        return za.flatMap(a -> zb.map(b -> ((Function1)mapper.curried().apply(a)).apply(b)));
    }

    public static <R, E, A> ZIO<R, E, A> absorb(ZIO<R, E, Either<E, A>> value) {
        return value.flatMap(either -> (ZIO)either.fold(ZIO::raiseError, ZIO::pure));
    }

    public static <R, A, B> Function1<A, ZIO<R, Throwable, B>> lift(Function1<A, B> function) {
        return value -> ZIO.task(() -> function.apply(value));
    }

    public static <R, E, A> ZIO<R, E, A> fromEither(Producer<Either<E, A>> task) {
        return new Task(task);
    }

    public static <R> ZIO<R, Throwable, Unit> exec(CheckedRunnable task) {
        return new Attempt(task.asProducer());
    }

    public static <R, E, A> ZIO<R, E, A> pure(A value) {
        return new Pure(value);
    }

    public static <R, E, A> ZIO<R, E, A> defer(Producer<ZIO<R, E, A>> lazy) {
        return new Suspend<R, E, A>(lazy);
    }

    public static <R, A> ZIO<R, Throwable, A> task(Producer<A> task) {
        return new Attempt(task);
    }

    public static <R, E, A> ZIO<R, E, A> raiseError(E error) {
        return new Failure(error);
    }

    public static <R, A> ZIO<R, Throwable, A> redeem(ZIO<R, Nothing, A> value) {
        return new Redeem<R, A>(value);
    }

    public static <R, A extends AutoCloseable, B> ZIO<R, Throwable, B> bracket(ZIO<R, Throwable, A> acquire, Function1<A, ZIO<R, Throwable, B>> use) {
        return new Bracket<R, A, B>(acquire, use, AutoCloseable::close);
    }

    public static <R, A, B> ZIO<R, Throwable, B> bracket(ZIO<R, Throwable, A> acquire, Function1<A, ZIO<R, Throwable, B>> use, Consumer1<A> release) {
        return new Bracket<R, A, B>(acquire, use, release);
    }

    public static <R, E> ZIO<R, E, Unit> unit() {
        return ZIOModule.UNIT;
    }

    public static <R, E, A> ZIO<R, E, A> narrowK(Higher1<Higher1<Higher1<\u00b5, R>, E>, A> hkt) {
        return (ZIO)hkt;
    }

    public static <R, E, A> ZIO<R, E, A> narrowK(Higher2<Higher1<\u00b5, R>, E, A> hkt) {
        return (ZIO)hkt;
    }

    public static <R, E, A> ZIO<R, E, A> narrowK(Higher3<\u00b5, R, E, A> hkt) {
        return (ZIO)hkt;
    }

    public static final class \u00b5
    implements Kind {
    }

    public static final class Bracket<R, A, B>
    implements ZIO<R, Throwable, B> {
        private final ZIO<R, Throwable, A> acquire;
        private final Function1<A, ZIO<R, Throwable, B>> use;
        private final Consumer1<A> release;

        protected Bracket(ZIO<R, Throwable, A> acquire, Function1<A, ZIO<R, Throwable, B>> use, Consumer1<A> release) {
            this.acquire = Objects.requireNonNull(acquire);
            this.use = Objects.requireNonNull(use);
            this.release = Objects.requireNonNull(release);
        }

        @Override
        public Either<Throwable, B> provide(R env) {
            try (ZIOResource<A> resource = new ZIOResource<A>(this.acquire.provide(env), this.release);){
                Either<Throwable, B> either = resource.apply(this.use).provide(env);
                return either;
            }
        }

        @Override
        public <F extends Kind> Higher1<F, Either<Throwable, B>> foldMap(R env, MonadDefer<F> monad) {
            return monad.bracket(monad.flatMap(this.acquire.foldMap(env, monad), arg_0 -> monad.fromEither(arg_0)), this.use.andThen(zio -> zio.foldMap(env, monad)), this.release);
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Bracket(" + this.acquire + ", ?, ?)";
        }
    }

    public static final class FoldM<R, E, A, F, B>
    implements ZIO<R, F, B> {
        private final ZIO<R, E, A> current;
        private final Function1<E, ZIO<R, F, B>> nextError;
        private final Function1<A, ZIO<R, F, B>> next;

        protected FoldM(ZIO<R, E, A> current, Function1<E, ZIO<R, F, B>> nextError, Function1<A, ZIO<R, F, B>> next) {
            this.current = Objects.requireNonNull(current);
            this.nextError = Objects.requireNonNull(nextError);
            this.next = Objects.requireNonNull(next);
        }

        @Override
        public Either<F, B> provide(R env) {
            return ((ZIO)this.current.provide(env).fold(this.nextError, this.next)).provide(env);
        }

        @Override
        public <X extends Kind> Higher1<X, Either<F, B>> foldMap(R env, MonadDefer<X> monad) {
            Higher1<X, Either<E, A>> foldMap = this.current.foldMap(env, monad);
            Higher1 map = monad.map(foldMap, either -> (ZIO)either.fold(this.nextError, this.next));
            return monad.flatMap(map, zio -> zio.foldMap(env, monad));
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "FoldM(" + this.current + ", ?, ?)";
        }
    }

    public static final class AccessM<R, E, A>
    implements ZIO<R, E, A> {
        private final Function1<R, ZIO<R, E, A>> function;

        protected AccessM(Function1<R, ZIO<R, E, A>> function) {
            this.function = Objects.requireNonNull(function);
        }

        @Override
        public Either<E, A> provide(R env) {
            return ((ZIO)this.function.apply(env)).provide(env);
        }

        @Override
        public <F extends Kind> Higher1<F, Either<E, A>> foldMap(R env, MonadDefer<F> monad) {
            Higher1 later = monad.later(() -> (ZIO)this.function.apply(env));
            return monad.flatMap(later, zio -> zio.foldMap(env, monad));
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "AccessM(?)";
        }
    }

    public static final class Redeem<R, A>
    implements ZIO<R, Throwable, A> {
        private final ZIO<R, Nothing, A> current;

        protected Redeem(ZIO<R, Nothing, A> current) {
            this.current = Objects.requireNonNull(current);
        }

        @Override
        public Either<Throwable, A> provide(R env) {
            return Try.of(() -> this.current.provide(env).get()).toEither();
        }

        @Override
        public <F extends Kind> Higher1<F, Either<Throwable, A>> foldMap(R env, MonadDefer<F> monad) {
            return monad.later(() -> this.provide(env));
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Redeem(" + this.current + ")";
        }
    }

    public static final class Attempt<R, A>
    implements ZIO<R, Throwable, A> {
        private final Producer<A> current;

        protected Attempt(Producer<A> current) {
            this.current = Objects.requireNonNull(current);
        }

        @Override
        public Either<Throwable, A> provide(R env) {
            return Try.of(this.current).toEither();
        }

        @Override
        public <F extends Kind> Higher1<F, Either<Throwable, A>> foldMap(R env, MonadDefer<F> monad) {
            return monad.later(() -> Try.of(this.current).toEither());
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Attempt(" + this.current + ")";
        }
    }

    public static final class Swap<R, E, A>
    implements ZIO<R, A, E> {
        private final ZIO<R, E, A> current;

        protected Swap(ZIO<R, E, A> current) {
            this.current = Objects.requireNonNull(current);
        }

        @Override
        public Either<A, E> provide(R env) {
            return this.current.provide(env).swap();
        }

        @Override
        public <F extends Kind> Higher1<F, Either<A, E>> foldMap(R env, MonadDefer<F> monad) {
            return monad.map(this.current.foldMap(env, monad), Either::swap);
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Swap(" + this.current + ")";
        }
    }

    public static final class Suspend<R, E, A>
    implements ZIO<R, E, A> {
        private final Producer<ZIO<R, E, A>> lazy;

        protected Suspend(Producer<ZIO<R, E, A>> lazy) {
            this.lazy = Objects.requireNonNull(lazy);
        }

        @Override
        public Either<E, A> provide(R env) {
            return ZIOModule.collapse(this).provide(env);
        }

        @Override
        public <B> ZIO<R, E, B> flatMap(Function1<A, ZIO<R, E, B>> map) {
            return new FlatMapped(() -> this.lazy.get(), ZIO::raiseError, arg_0 -> map.apply(arg_0));
        }

        @Override
        public <F extends Kind> Higher1<F, Either<E, A>> foldMap(R env, MonadDefer<F> monad) {
            return monad.defer(() -> ((ZIO)this.lazy.get()).foldMap(env, monad));
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        protected ZIO<R, E, A> next() {
            return (ZIO)this.lazy.get();
        }

        public String toString() {
            return "Suspend(?)";
        }
    }

    public static final class Task<R, E, A>
    implements ZIO<R, E, A> {
        private final Producer<Either<E, A>> task;

        protected Task(Producer<Either<E, A>> task) {
            this.task = Objects.requireNonNull(task);
        }

        @Override
        public Either<E, A> provide(R env) {
            return (Either)this.task.get();
        }

        @Override
        public <F extends Kind> Higher1<F, Either<E, A>> foldMap(R env, MonadDefer<F> monad) {
            return monad.later(() -> this.task.get());
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Task(?)";
        }
    }

    public static final class FlatMapped<R, E, A, F, B>
    implements ZIO<R, F, B> {
        private final Producer<ZIO<R, E, A>> current;
        private final Function1<E, ZIO<R, F, B>> nextError;
        private final Function1<A, ZIO<R, F, B>> next;

        protected FlatMapped(Producer<ZIO<R, E, A>> current, Function1<E, ZIO<R, F, B>> nextError, Function1<A, ZIO<R, F, B>> next) {
            this.current = Objects.requireNonNull(current);
            this.nextError = Objects.requireNonNull(nextError);
            this.next = Objects.requireNonNull(next);
        }

        @Override
        public Either<F, B> provide(R env) {
            return ZIOModule.evaluate(env, this);
        }

        @Override
        public <F1, B1> ZIO<R, F1, B1> biflatMap(Function1<F, ZIO<R, F1, B1>> left, Function1<B, ZIO<R, F1, B1>> right) {
            return new FlatMapped<R, E, A, F, B>(() -> this.start(), f -> new FlatMapped<R, E, A, F, B>(() -> this.run(Either.left((Object)f)), arg_0 -> ((Function1)left).apply(arg_0), arg_0 -> ((Function1)right).apply(arg_0)), b -> new FlatMapped<R, E, A, F, B>(() -> this.run(Either.right((Object)b)), arg_0 -> ((Function1)left).apply(arg_0), arg_0 -> ((Function1)right).apply(arg_0)));
        }

        @Override
        public <X extends Kind> Higher1<X, Either<F, B>> foldMap(R env, MonadDefer<X> monad) {
            Higher1 foldMap = ((ZIO)this.current.get()).foldMap(env, monad);
            Higher1 map = monad.map(foldMap, either -> (ZIO)either.bimap(this.nextError, this.next).fold(Function1.identity(), Function1.identity()));
            return monad.flatMap(map, zio -> zio.foldMap(env, monad));
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "FlatMapped(" + this.current + ", ?, ?)";
        }

        protected ZIO<R, E, A> start() {
            return (ZIO)this.current.get();
        }

        protected ZIO<R, F, B> run(Either<E, A> value) {
            return (ZIO)value.bimap(this.nextError, this.next).fold(Function1.identity(), Function1.identity());
        }
    }

    public static final class Failure<R, E, A>
    implements ZIO<R, E, A> {
        private E error;

        protected Failure(E error) {
            this.error = Objects.requireNonNull(error);
        }

        @Override
        public Either<E, A> provide(R env) {
            return Either.left(this.error);
        }

        @Override
        public <F extends Kind> Higher1<F, Either<E, A>> foldMap(R env, MonadDefer<F> monad) {
            return monad.pure((Object)Either.left(this.error));
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Failure(" + this.error + ")";
        }
    }

    public static final class Pure<R, E, A>
    implements ZIO<R, E, A> {
        private final A value;

        protected Pure(A value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public Either<E, A> provide(R env) {
            return Either.right(this.value);
        }

        @Override
        public <F extends Kind> Higher1<F, Either<E, A>> foldMap(R env, MonadDefer<F> monad) {
            return monad.pure((Object)Either.right(this.value));
        }

        @Override
        public ZIOModule getModule() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Pure(" + this.value + ")";
        }
    }
}

