/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Unit;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.ZIO;
import com.github.tonivade.purefun.type.Either;
import java.util.Stack;

interface ZIOModule {
    public static final ZIO<?, ?, Unit> UNIT = ZIO.pure(Unit.unit());

    public static <R, E, A, F, B> ZIO<R, E, A> collapse(ZIO<R, E, A> self) {
        ZIO<R, E, A> current = self;
        while (current instanceof ZIO.Suspend) {
            ZIO.Suspend suspend = (ZIO.Suspend)current;
            current = suspend.next();
        }
        if (current instanceof ZIO.FlatMapped) {
            ZIO.FlatMapped flatMapped = (ZIO.FlatMapped)current;
            return new ZIO.FlatMapped(flatMapped::start, e -> ZIOModule.collapse(flatMapped.run(Either.left((Object)e))), a -> ZIOModule.collapse(flatMapped.run(Either.right((Object)a))));
        }
        return current;
    }

    public static <R, E, A> Either<E, A> evaluate(R env, ZIO<R, E, A> self) {
        Stack<Function1> stack = new Stack<Function1>();
        ZIO<R, Object, Object> current = self;
        while (true) {
            if (current instanceof ZIO.FlatMapped) {
                ZIO.FlatMapped currentFlatMapped = (ZIO.FlatMapped)current;
                ZIO next = currentFlatMapped.start();
                if (next instanceof ZIO.FlatMapped) {
                    ZIO.FlatMapped nextFlatMapped = (ZIO.FlatMapped)next;
                    current = nextFlatMapped.start();
                    stack.push(currentFlatMapped::run);
                    stack.push(nextFlatMapped::run);
                    continue;
                }
                current = currentFlatMapped.run(next.provide(env));
                continue;
            }
            if (stack.isEmpty()) break;
            current = (ZIO)((Function1)stack.pop()).apply(current.provide(env));
        }
        return current.provide(env);
    }

    public static <R, E, A> ZIO<R, E, A> repeat(ZIO<R, E, A> self, UIO<Unit> delay, int times) {
        return self.foldM(ZIO::raiseError, value -> {
            if (times > 0) {
                return delay.toZIO().andThen(ZIOModule.repeat(self, delay, times - 1));
            }
            return ZIO.pure(value);
        });
    }

    public static <R, E, A> ZIO<R, E, A> retry(ZIO<R, E, A> self, UIO<Unit> delay, int maxRetries) {
        return self.foldM(error -> {
            if (maxRetries > 0) {
                return delay.toZIO().andThen(ZIOModule.retry(self, delay.repeat(), maxRetries - 1));
            }
            return ZIO.raiseError(error);
        }, ZIO::pure);
    }
}

