/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect.util;

import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Unit;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.ZIO;
import java.time.Duration;
import java.time.OffsetDateTime;

public interface ZClock {
    public <R extends ZClock> Service<R> clock();

    public static <R extends ZClock> ZIO<R, Nothing, Long> currentTime() {
        return ZIO.accessM(env -> env.clock().currentTime());
    }

    public static <R extends ZClock> ZIO<R, Nothing, OffsetDateTime> currentDateTime() {
        return ZIO.accessM(env -> env.clock().currentDateTime());
    }

    public static <R extends ZClock> ZIO<R, Nothing, Unit> sleep(Duration duration) {
        return ZIO.accessM(env -> env.clock().sleep(duration));
    }

    public static ZClock live() {
        return new ZClock(){

            @Override
            public <R extends ZClock> Service<R> clock() {
                return new Service<R>(){

                    @Override
                    public ZIO<R, Nothing, Long> currentTime() {
                        return UIO.task(System::currentTimeMillis).toZIO();
                    }

                    @Override
                    public ZIO<R, Nothing, OffsetDateTime> currentDateTime() {
                        return UIO.task(OffsetDateTime::now).toZIO();
                    }

                    @Override
                    public ZIO<R, Nothing, Unit> sleep(Duration duration) {
                        return UIO.exec(() -> Thread.sleep(duration.toMillis())).toZIO();
                    }
                };
            }
        };
    }

    public static interface Service<R extends ZClock> {
        public ZIO<R, Nothing, Long> currentTime();

        public ZIO<R, Nothing, OffsetDateTime> currentDateTime();

        public ZIO<R, Nothing, Unit> sleep(Duration var1);
    }
}

