/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect.util;

import com.github.tonivade.purefun.Unit;
import com.github.tonivade.purefun.effect.ZIO;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Queue;

public interface ZConsole {
    public <R extends ZConsole> Service<R> console();

    public static <R extends ZConsole> ZIO<R, Throwable, String> readln() {
        return ZIO.accessM(env -> env.console().readln());
    }

    public static <R extends ZConsole> ZIO<R, Throwable, Unit> println(String text) {
        return ZIO.accessM(env -> env.console().println(text));
    }

    public static ZConsole test(final Queue<String> input, final Queue<String> output) {
        return new ZConsole(){

            @Override
            public <R extends ZConsole> Service<R> console() {
                return new Service<R>(){

                    @Override
                    public ZIO<R, Throwable, String> readln() {
                        return ZIO.task(input::poll);
                    }

                    @Override
                    public ZIO<R, Throwable, Unit> println(String text) {
                        return ZIO.exec(() -> output.offer(text));
                    }
                };
            }
        };
    }

    public static ZConsole live() {
        return new ZConsole(){

            @Override
            public <R extends ZConsole> Service<R> console() {
                return new Service<R>(){

                    @Override
                    public ZIO<R, Throwable, String> readln() {
                        return ZIO.task(() -> this.reader().readLine());
                    }

                    @Override
                    public ZIO<R, Throwable, Unit> println(String text) {
                        return ZIO.exec(() -> this.writer().println(text));
                    }

                    private BufferedReader reader() {
                        return new BufferedReader(new InputStreamReader(System.in));
                    }

                    private PrintWriter writer() {
                        return new PrintWriter(System.out, true);
                    }
                };
            }
        };
    }

    public static interface Service<R extends ZConsole> {
        public ZIO<R, Throwable, String> readln();

        public ZIO<R, Throwable, Unit> println(String var1);
    }
}

