/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect.util;

import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.ZIO;
import com.github.tonivade.purefun.effect.util.ZRandom;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class ZRandomImpl
implements ZRandom {
    private static final String PRINTABLE_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private Random random;

    ZRandomImpl(Random random) {
        this.random = Objects.requireNonNull(random);
    }

    @Override
    public <R extends ZRandom> ZRandom.Service<R> random() {
        return new ZRandom.Service<R>(){

            @Override
            public ZIO<R, Nothing, Integer> nextInt() {
                return UIO.task(ZRandomImpl.this.random::nextInt).toZIO();
            }

            @Override
            public ZIO<R, Nothing, Long> nextLong() {
                return UIO.task(ZRandomImpl.this.random::nextLong).toZIO();
            }

            @Override
            public ZIO<R, Nothing, Float> nextFloat() {
                return UIO.task(ZRandomImpl.this.random::nextFloat).toZIO();
            }

            @Override
            public ZIO<R, Nothing, Double> nextDouble() {
                return UIO.task(ZRandomImpl.this.random::nextDouble).toZIO();
            }

            @Override
            public ZIO<R, Nothing, Character> nextChar() {
                return UIO.task(this::randomChar).toZIO();
            }

            @Override
            public ZIO<R, Nothing, String> nextString(int length) {
                return UIO.task(() -> this.randomString(length)).toZIO();
            }

            private Character randomChar() {
                return Character.valueOf(ZRandomImpl.PRINTABLE_CHARS.charAt(ZRandomImpl.this.random.nextInt(ZRandomImpl.PRINTABLE_CHARS.length())));
            }

            private String randomString(int length) {
                return IntStream.range(0, length).mapToObj(x -> this.randomChar()).map(Object::toString).collect(Collectors.joining());
            }
        };
    }
}

