/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicStatusManagerTest {
    BasicStatusManager bsm = new BasicStatusManager();
    Context context = new ContextBase();
    ContextAware contextAware = new ContextAwareBase();
    OnConsoleStatusListener csl = new OnConsoleStatusListener();

    @Before
    public void before() {
        this.contextAware.setContext(this.context);
        this.csl.setContext(this.context);
        this.bsm.clear();
    }

    @Test
    public void smoke() {
        this.bsm.add((Status)new ErrorStatus("hello", (Object)this));
        junit.framework.Assert.assertEquals((int)2, (int)this.bsm.getLevel());
        List list = this.bsm.getCopyOfStatusList();
        junit.framework.Assert.assertNotNull((Object)list);
        junit.framework.Assert.assertEquals((int)1, (int)list.size());
        junit.framework.Assert.assertEquals((String)"hello", (String)((Status)list.get(0)).getMessage());
    }

    @Test
    public void many() {
        int n;
        int n2 = 300;
        int n3 = 300 + n2;
        for (int i = 0; i < n3; ++i) {
            this.bsm.add((Status)new ErrorStatus("" + i, (Object)this));
        }
        List list = this.bsm.getCopyOfStatusList();
        junit.framework.Assert.assertNotNull((Object)list);
        junit.framework.Assert.assertEquals((int)300, (int)list.size());
        ArrayList<ErrorStatus> arrayList = new ArrayList<ErrorStatus>();
        for (n = 0; n < 150; ++n) {
            arrayList.add(new ErrorStatus("" + n, (Object)this));
        }
        for (n = 0; n < 150; ++n) {
            arrayList.add(new ErrorStatus("" + (150 + n2 + n), (Object)this));
        }
        junit.framework.Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void returnsTrueForNewlyAddedConsoleListener() {
        Assert.assertTrue((boolean)this.bsm.addUniquely((StatusListener)this.csl, (Object)this.contextAware));
        junit.framework.Assert.assertEquals(OnConsoleStatusListener.class, ((StatusListener)this.bsm.getCopyOfStatusListenerList().get(0)).getClass());
        List list = this.bsm.getCopyOfStatusListenerList();
        junit.framework.Assert.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void returnsFalseWhenNoConsoleListenerAdded() {
        this.bsm.addUniquely((StatusListener)this.csl, (Object)this.contextAware);
        Assert.assertFalse((boolean)this.bsm.addUniquely((StatusListener)this.csl, (Object)this.contextAware));
        List list = this.bsm.getCopyOfStatusListenerList();
        junit.framework.Assert.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void addsConsoleStatusListenerOnlyIfAbsent() {
        this.bsm.addUniquely((StatusListener)this.csl, (Object)this.contextAware);
        List list = this.bsm.getCopyOfStatusListenerList();
        junit.framework.Assert.assertEquals((int)1, (int)list.size());
        junit.framework.Assert.assertEquals((Object)this.csl, list.get(0));
        this.bsm.addUniquely((StatusListener)this.csl, (Object)this.contextAware);
        list = this.bsm.getCopyOfStatusListenerList();
        junit.framework.Assert.assertEquals((int)1, (int)list.size());
        junit.framework.Assert.assertEquals((Object)this.csl, list.get(0));
    }
}

