/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Runner;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.ResilienceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class FileAppenderResilienceTest {
    FileAppender<Object> fa = new FileAppender();
    Context context = new ContextBase();
    int diff = RandomUtil.getPositiveInt();
    String outputDirStr = "target/test-output/resilience-" + this.diff + "/";
    String logfileStr = this.outputDirStr + "output.log";

    @Before
    public void setUp() throws InterruptedException {
        OnConsoleStatusListener.addNewInstanceToContext((Context)this.context);
        File file = new File(this.outputDirStr);
        file.mkdirs();
        this.fa.setContext(this.context);
        this.fa.setName("FILE");
        this.fa.setEncoder((Encoder)new EchoEncoder());
        this.fa.setFile(this.logfileStr);
        this.fa.start();
    }

    @Test
    @Ignore
    public void manual() throws InterruptedException, IOException {
        Runner runner = new Runner(this.fa);
        Thread thread = new Thread(runner);
        thread.start();
        while (true) {
            Thread.sleep(110L);
        }
    }

    @Test
    public void smoke() throws InterruptedException, IOException {
        Runner runner = new Runner(this.fa);
        Thread thread = new Thread(runner);
        thread.start();
        double d = 2.0;
        for (int i = 0; i < 5; ++i) {
            Thread.sleep((int)(20.0 * d));
            this.closeLogFileOnPurpose();
        }
        runner.setDone(true);
        thread.join();
        double d2 = 1.0 / d;
        double d3 = 0.35;
        double d4 = 1.0 - d3;
        ResilienceUtil.verify(this.logfileStr, "^hello (\\d{1,5})$", runner.getCounter(), d2 * d4);
    }

    private void closeLogFileOnPurpose() throws IOException {
        ResilientFileOutputStream resilientFileOutputStream = (ResilientFileOutputStream)this.fa.getOutputStream();
        FileChannel fileChannel = resilientFileOutputStream.getChannel();
        fileChannel.close();
    }
}

