/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.pattern.parser.SamplePatternLayout;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OutputStreamAppenderTest {
    Context context = new ContextBase();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void smoke() {
        String string = "FILE_HEADER ";
        String string2 = "PRESENTATION_HEADER";
        String string3 = "PRESENTATION_FOOTER ";
        String string4 = "FILE_FOOTER";
        this.headerFooterCheck(string, string2, string3, string4);
    }

    @Test
    public void nullFileHeader() {
        String string = null;
        String string2 = "PRESENTATION_HEADER";
        String string3 = "PRESENTATION_FOOTER ";
        String string4 = "FILE_FOOTER";
        this.headerFooterCheck(string, string2, string3, string4);
    }

    @Test
    public void nullPresentationHeader() {
        String string = "FILE_HEADER ";
        String string2 = null;
        String string3 = "PRESENTATION_FOOTER ";
        String string4 = "FILE_FOOTER";
        this.headerFooterCheck(string, string2, string3, string4);
    }

    @Test
    public void nullPresentationFooter() {
        String string = "FILE_HEADER ";
        String string2 = "PRESENTATION_HEADER";
        String string3 = null;
        String string4 = "FILE_FOOTER";
        this.headerFooterCheck(string, string2, string3, string4);
    }

    @Test
    public void nullFileFooter() {
        String string = "FILE_HEADER ";
        String string2 = "PRESENTATION_HEADER";
        String string3 = "PRESENTATION_FOOTER ";
        String string4 = null;
        this.headerFooterCheck(string, string2, string3, string4);
    }

    public void headerFooterCheck(String string, String string2, String string3, String string4) {
        OutputStreamAppender outputStreamAppender = new OutputStreamAppender();
        outputStreamAppender.setContext(this.context);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SamplePatternLayout samplePatternLayout = new SamplePatternLayout();
        samplePatternLayout.setContext(this.context);
        samplePatternLayout.setFileHeader(string);
        samplePatternLayout.setPresentationHeader(string2);
        samplePatternLayout.setPresentationFooter(string3);
        samplePatternLayout.setFileFooter(string4);
        samplePatternLayout.start();
        LayoutWrappingEncoder layoutWrappingEncoder = new LayoutWrappingEncoder();
        layoutWrappingEncoder.setLayout(samplePatternLayout);
        layoutWrappingEncoder.setContext(this.context);
        outputStreamAppender.setEncoder((Encoder)layoutWrappingEncoder);
        outputStreamAppender.setOutputStream((OutputStream)byteArrayOutputStream);
        outputStreamAppender.start();
        outputStreamAppender.stop();
        String string5 = byteArrayOutputStream.toString();
        String string6 = this.emtptyIfNull(string) + this.emtptyIfNull(string2);
        System.out.println(string5);
        Assert.assertTrue((String)string5, (boolean)string5.startsWith(string6));
        String string7 = this.emtptyIfNull(string3) + this.emtptyIfNull(string4);
        Assert.assertTrue((String)string5, (boolean)string5.endsWith(string7));
    }

    String emtptyIfNull(String string) {
        return string == null ? "" : string;
    }
}

