/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import junit.framework.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAppenderTest<E> {
    Context context = new ContextBase();

    protected abstract Appender<E> getAppender();

    protected abstract Appender<E> getConfiguredAppender();

    @Test
    public void testNewAppender() {
        Appender<E> appender = this.getAppender();
        Assert.assertFalse((boolean)appender.isStarted());
    }

    @Test
    public void testConfiguredAppender() {
        Appender<E> appender = this.getConfiguredAppender();
        appender.start();
        Assert.assertTrue((boolean)appender.isStarted());
        appender.stop();
        Assert.assertFalse((boolean)appender.isStarted());
    }

    @Test
    public void testNoStart() {
        Appender<E> appender = this.getAppender();
        appender.setContext(this.context);
        appender.setName("doh");
        appender.doAppend(null);
        StatusChecker statusChecker = new StatusChecker(this.context.getStatusManager());
        StatusPrinter.print((Context)this.context);
        statusChecker.assertContainsMatch("Attempted to append to non started appender \\[doh\\].");
    }
}

