/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.appender.XTeeOutputStream;
import ch.qos.logback.core.encoder.DummyEncoder;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.NopEncoder;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.status.StatusChecker;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleAppenderTest
extends AbstractAppenderTest<Object> {
    XTeeOutputStream tee;
    PrintStream original;

    @Before
    public void setUp() {
        this.original = System.out;
        this.tee = new XTeeOutputStream(null);
        System.setOut(new PrintStream(this.tee));
    }

    @After
    public void tearDown() {
        System.setOut(this.original);
    }

    @Override
    public Appender<Object> getAppender() {
        return new ConsoleAppender();
    }

    @Override
    protected Appender<Object> getConfiguredAppender() {
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setEncoder(new NopEncoder());
        consoleAppender.start();
        return consoleAppender;
    }

    @Test
    public void testBasic() {
        ConsoleAppender consoleAppender = (ConsoleAppender)this.getAppender();
        consoleAppender.setEncoder(new DummyEncoder());
        consoleAppender.start();
        consoleAppender.doAppend(new Object());
        Assert.assertEquals((String)DummyLayout.DUMMY, (String)this.tee.toString());
    }

    @Test
    public void testOpen() {
        ConsoleAppender consoleAppender = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        dummyEncoder.setFileHeader("open");
        consoleAppender.setEncoder(dummyEncoder);
        consoleAppender.start();
        consoleAppender.doAppend(new Object());
        consoleAppender.stop();
        Assert.assertEquals((String)("open" + CoreConstants.LINE_SEPARATOR + DummyLayout.DUMMY), (String)this.tee.toString());
    }

    @Test
    public void testClose() {
        ConsoleAppender consoleAppender = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        dummyEncoder.setFileFooter("CLOSED");
        consoleAppender.setEncoder(dummyEncoder);
        consoleAppender.start();
        consoleAppender.doAppend(new Object());
        consoleAppender.stop();
        Assert.assertFalse((boolean)this.tee.isClosed());
        Assert.assertEquals((String)(DummyLayout.DUMMY + "CLOSED"), (String)this.tee.toString());
    }

    @Test
    public void changeInConsole() {
        ConsoleAppender consoleAppender = (ConsoleAppender)this.getAppender();
        EchoEncoder echoEncoder = new EchoEncoder();
        consoleAppender.setEncoder((Encoder)echoEncoder);
        consoleAppender.start();
        consoleAppender.doAppend((Object)"a");
        Assert.assertEquals((String)("a" + CoreConstants.LINE_SEPARATOR), (String)this.tee.toString());
        XTeeOutputStream xTeeOutputStream = new XTeeOutputStream(null);
        System.setOut(new PrintStream(xTeeOutputStream));
        consoleAppender.doAppend((Object)"b");
        Assert.assertEquals((String)("b" + CoreConstants.LINE_SEPARATOR), (String)xTeeOutputStream.toString());
    }

    @Test
    public void testUTF16BE() throws UnsupportedEncodingException {
        ConsoleAppender consoleAppender = (ConsoleAppender)this.getAppender();
        DummyEncoder dummyEncoder = new DummyEncoder();
        String string = "UTF-16BE";
        dummyEncoder.setEncodingName(string);
        consoleAppender.setEncoder(dummyEncoder);
        consoleAppender.start();
        consoleAppender.doAppend(new Object());
        Assert.assertEquals((String)DummyLayout.DUMMY, (String)new String(this.tee.toByteArray(), string));
    }

    @Test
    public void wrongTarget() {
        ConsoleAppender consoleAppender = (ConsoleAppender)this.getAppender();
        EchoEncoder echoEncoder = new EchoEncoder();
        echoEncoder.setContext(this.context);
        consoleAppender.setContext(this.context);
        consoleAppender.setTarget("foo");
        consoleAppender.setEncoder((Encoder)echoEncoder);
        consoleAppender.start();
        consoleAppender.doAppend((Object)"a");
        StatusChecker statusChecker = new StatusChecker(this.context);
        statusChecker.assertContainsMatch(1, "\\[foo\\] should be one of \\[SystemOut, SystemErr\\]");
    }
}

