/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.NOPOutputStream;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.encoder.DummyEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.NopEncoder;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAppenderTest
extends AbstractAppenderTest<Object> {
    private int diff = RandomUtil.getPositiveInt();

    @Override
    protected Appender<Object> getAppender() {
        return new FileAppender();
    }

    @Override
    protected Appender<Object> getConfiguredAppender() {
        FileAppender fileAppender = new FileAppender();
        fileAppender.setEncoder(new NopEncoder());
        fileAppender.setFile("target/test-output/temp.log");
        fileAppender.setName("test");
        fileAppender.setContext(this.context);
        fileAppender.start();
        return fileAppender;
    }

    @Test
    public void smoke() {
        String string = "target/test-output//fat-smoke.log";
        FileAppender fileAppender = new FileAppender();
        fileAppender.setEncoder(new DummyEncoder());
        fileAppender.setAppend(false);
        fileAppender.setFile(string);
        fileAppender.setName("smoke");
        fileAppender.setContext(this.context);
        fileAppender.start();
        fileAppender.doAppend(new Object());
        fileAppender.stop();
        File file = new File(string);
        junit.framework.Assert.assertTrue((boolean)file.exists());
        junit.framework.Assert.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
    }

    @Test
    public void testCreateParentFolders() {
        String string = "target/test-output//fat-testCreateParentFolders-" + this.diff + "/testCreateParentFolders.txt";
        File file = new File(string);
        FileAppender fileAppender = new FileAppender();
        fileAppender.setEncoder(new DummyEncoder());
        fileAppender.setAppend(false);
        fileAppender.setFile(string);
        fileAppender.setName("testCreateParentFolders");
        fileAppender.setContext(this.context);
        fileAppender.start();
        fileAppender.doAppend(new Object());
        fileAppender.stop();
        junit.framework.Assert.assertFalse((boolean)FileUtil.isParentDirectoryCreationRequired((File)file));
        junit.framework.Assert.assertTrue((boolean)file.exists());
        junit.framework.Assert.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
        File file2 = file.getParentFile();
        junit.framework.Assert.assertTrue((String)("failed to delete " + file2.getAbsolutePath()), (boolean)file2.delete());
    }

    @Test
    public void testPrudentModeLogicalImplications() {
        String string = "target/test-output/" + this.diff + "fat-testPrudentModeLogicalImplications.txt";
        File file = new File(string);
        FileAppender fileAppender = new FileAppender();
        fileAppender.setEncoder(new DummyEncoder());
        fileAppender.setFile(string);
        fileAppender.setName("testPrudentModeLogicalImplications");
        fileAppender.setContext(this.context);
        fileAppender.setAppend(false);
        fileAppender.setPrudent(true);
        fileAppender.start();
        junit.framework.Assert.assertTrue((boolean)fileAppender.isAppend());
        StatusManager statusManager = this.context.getStatusManager();
        StatusChecker statusChecker = new StatusChecker(this.context);
        junit.framework.Assert.assertEquals((int)1, (int)statusChecker.getHighestLevel(0L));
        List list = statusManager.getCopyOfStatusList();
        junit.framework.Assert.assertTrue((String)("Expecting status list size to be 2 or larger, but was " + list.size()), (list.size() >= 2 ? 1 : 0) != 0);
        String string2 = ((Status)list.get(1)).getMessage();
        junit.framework.Assert.assertTrue((String)("Got message [" + string2 + "]"), (boolean)string2.startsWith("Setting \"Append\" property"));
        fileAppender.doAppend(new Object());
        fileAppender.stop();
        junit.framework.Assert.assertTrue((boolean)file.exists());
        junit.framework.Assert.assertTrue((String)("failed to delete " + file.getAbsolutePath()), (boolean)file.delete());
    }

    private FileAppenderFriend<Object> getFileAppender(String string) {
        FileAppenderFriend<Object> fileAppenderFriend = new FileAppenderFriend<Object>();
        fileAppenderFriend.setEncoder((Encoder)new DummyEncoder());
        fileAppenderFriend.setFile(string);
        fileAppenderFriend.setName("testPrudentMode");
        fileAppenderFriend.setContext(this.context);
        fileAppenderFriend.setAppend(false);
        fileAppenderFriend.setPrudent(true);
        return fileAppenderFriend;
    }

    @Test
    public void unlazyAppenderOpensFileAtStart() {
        String string = "target/test-output/" + this.diff + "testing.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        FileAppenderFriend<Object> fileAppenderFriend = this.getFileAppender(string);
        fileAppenderFriend.setLazy(false);
        Assert.assertNull((String)"stream is not null", (Object)fileAppenderFriend.getOutputStream());
        fileAppenderFriend.start();
        junit.framework.Assert.assertTrue((String)("expected ResilientFileOutputStream; actual " + fileAppenderFriend.getOutputStream().getClass().getSimpleName()), (boolean)(fileAppenderFriend.getOutputStream() instanceof ResilientFileOutputStream));
        junit.framework.Assert.assertTrue((String)"file does not exist", (boolean)file.exists());
    }

    @Test
    public void lazyAppenderDoesNotOpenFileAtStart() {
        String string = "target/test-output/" + this.diff + "testing.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        FileAppenderFriend<Object> fileAppenderFriend = this.getFileAppender(string);
        fileAppenderFriend.setLazy(true);
        Assert.assertNull((String)"stream is not null", (Object)fileAppenderFriend.getOutputStream());
        fileAppenderFriend.start();
        junit.framework.Assert.assertTrue((String)("expected NOPOutputStream; actual " + fileAppenderFriend.getOutputStream().getClass().getSimpleName()), (boolean)(fileAppenderFriend.getOutputStream() instanceof NOPOutputStream));
        junit.framework.Assert.assertFalse((String)"file does not exist", (boolean)file.exists());
    }

    @Test
    public void lazyAppenderOpensFileOnAppend() {
        String string = "target/test-output/" + this.diff + "testing.txt";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        FileAppenderFriend<Object> fileAppenderFriend = this.getFileAppender(string);
        fileAppenderFriend.setLazy(true);
        fileAppenderFriend.start();
        junit.framework.Assert.assertTrue((String)("expected NOPOutputStream; actual " + fileAppenderFriend.getOutputStream().getClass().getSimpleName()), (boolean)(fileAppenderFriend.getOutputStream() instanceof NOPOutputStream));
        fileAppenderFriend.append(new Object());
        junit.framework.Assert.assertTrue((String)("expected ResilientFileOutputStream; actual " + fileAppenderFriend.getOutputStream().getClass().getSimpleName()), (boolean)(fileAppenderFriend.getOutputStream() instanceof ResilientFileOutputStream));
        junit.framework.Assert.assertTrue((String)"file does not exist", (boolean)file.exists());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileAppenderFriend<E>
    extends FileAppender<E> {
        FileAppenderFriend() {
        }

        public void append(E e) {
            this.subAppend(e);
        }
    }
}

