/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.encoder.ByteArrayUtil;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class ByteArrayUtilTest {
    int BA_SIZE = 16;
    byte[] byteArray = new byte[this.BA_SIZE];
    Random random = new Random(18532235L);

    @Test
    public void smoke() {
        this.verifyLoop(this.byteArray, 0, 0);
        this.verifyLoop(this.byteArray, 0, 10);
        this.verifyLoop(this.byteArray, 0, Integer.MAX_VALUE);
        this.verifyLoop(this.byteArray, 0, Integer.MIN_VALUE);
    }

    @Test
    public void random() {
        for (int i = 0; i < 100000; ++i) {
            int n = this.random.nextInt(this.BA_SIZE - 4);
            int n2 = this.random.nextInt();
            this.verifyLoop(this.byteArray, n, n2);
        }
    }

    void verifyLoop(byte[] byArray, int n, int n2) {
        ByteArrayUtil.writeInt((byte[])this.byteArray, (int)n, (int)n2);
        int n3 = ByteArrayUtil.readInt((byte[])this.byteArray, (int)n);
        Assert.assertEquals((int)n2, (int)n3);
    }
}

