/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyEncoder<E>
extends EncoderBase<E> {
    public static final String DUMMY = "dummy" + CoreConstants.LINE_SEPARATOR;
    String val = DUMMY;
    String fileHeader;
    String fileFooter;
    String encodingName;

    public String getEncodingName() {
        return this.encodingName;
    }

    public void setEncodingName(String string) {
        this.encodingName = string;
    }

    public DummyEncoder() {
    }

    public DummyEncoder(String string) {
        this.val = string;
    }

    public void doEncode(E e) throws IOException {
        this.writeOut(this.val);
    }

    private void appendIfNotNull(StringBuilder stringBuilder, String string) {
        if (string != null) {
            stringBuilder.append(string);
        }
    }

    void writeOut(String string) throws IOException {
        if (this.encodingName == null) {
            this.outputStream.write(string.getBytes());
        } else {
            this.outputStream.write(string.getBytes(this.encodingName));
        }
    }

    void writeHeader() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendIfNotNull(stringBuilder, this.fileHeader);
        if (stringBuilder.length() > 0) {
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            this.writeOut(stringBuilder.toString());
        }
    }

    public void init(OutputStream outputStream) throws IOException {
        super.init(outputStream);
        this.writeHeader();
    }

    public void close() throws IOException {
        if (this.fileFooter == null) {
            return;
        }
        if (this.encodingName == null) {
            this.outputStream.write(this.fileFooter.getBytes());
        } else {
            this.outputStream.write(this.fileFooter.getBytes(this.encodingName));
        }
    }

    public String getFileHeader() {
        return this.fileHeader;
    }

    public void setFileHeader(String string) {
        this.fileHeader = string;
    }

    public String getFileFooter() {
        return this.fileFooter;
    }

    public void setFileFooter(String string) {
        this.fileFooter = string;
    }
}

