/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.encoder.EventObjectInputStream;
import ch.qos.logback.core.encoder.ObjectStreamEncoder;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectEncodeDecodeTest {
    ObjectStreamEncoder<String> encoder = new ObjectStreamEncoder();
    EventObjectInputStream<String> eventStream;
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDir = "target/test-output/" + this.diff + "/";

    @Before
    public void setUp() {
        File file = new File(this.randomOutputDir);
        file.mkdirs();
    }

    void encodeList(File file, List<String> list) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.encoder.init((OutputStream)fileOutputStream);
        for (String string : list) {
            this.encoder.doEncode((Object)string);
        }
        this.encoder.close();
        fileOutputStream.close();
    }

    List<String> decodeList(File file) throws IOException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        this.eventStream = new EventObjectInputStream((InputStream)fileInputStream);
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = (String)this.eventStream.readEvent()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Test
    public void singleBatch() throws IOException {
        File file = new File(this.randomOutputDir + "x.lbo");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            arrayList.add("hello" + i);
        }
        this.encodeList(file, arrayList);
        List<String> list = this.decodeList(file);
        Assert.assertEquals(arrayList, list);
    }

    @Test
    public void multipleBatches() throws IOException {
        File file = new File(this.randomOutputDir + "m.lbo");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            arrayList.add("hello" + i);
        }
        this.encodeList(file, arrayList);
        List<String> list = this.decodeList(file);
        Assert.assertEquals(arrayList, list);
    }
}

