/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ThrowableToStringArrayTest {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(this.sw);

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public void verify(Throwable throwable) {
        throwable.printStackTrace(this.pw);
        String[] stringArray = ThrowableToStringArray.convert((Throwable)throwable);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        String string = this.sw.toString();
        String string2 = stringBuilder.toString().replace("common frames omitted", "more");
        Assert.assertEquals((String)string, (String)string2);
    }

    @Test
    public void smoke() {
        Exception exception = new Exception("smoke");
        this.verify(exception);
    }

    @Test
    public void nested() {
        Exception exception = null;
        try {
            this.someMethod();
        }
        catch (Exception exception2) {
            exception = new Exception("wrapping", exception2);
        }
        this.verify(exception);
    }

    @Test
    public void multiNested() {
        Exception exception = null;
        try {
            this.someOtherMethod();
        }
        catch (Exception exception2) {
            exception = new Exception("wrapping", exception2);
        }
        this.verify(exception);
    }

    void someMethod() throws Exception {
        throw new Exception("someMethod");
    }

    void someOtherMethod() throws Exception {
        try {
            this.someMethod();
        }
        catch (Exception exception) {
            throw new Exception("someOtherMethod", exception);
        }
    }
}

