/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.issue;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LBCORE97 {
    static int THREAD_COUNT = 10;

    public static void main(String[] stringArray) throws InterruptedException {
        System.out.println("Environment:");
        System.out.println("java.runtime.name    = " + System.getProperty("java.runtime.name"));
        System.out.println("java.runtime.version = " + System.getProperty("java.runtime.version"));
        System.out.println("java.vendor          = " + System.getProperty("java.vendor"));
        System.out.println("java.version         = " + System.getProperty("java.version"));
        System.out.println("java.vm.name         = " + System.getProperty("java.vm.name"));
        System.out.println("java.vm.info         = " + System.getProperty("java.vm.info"));
        System.out.println("os.name              = " + System.getProperty("os.name"));
        System.out.println("os.version           = " + System.getProperty("os.version"));
        System.out.println("os.arch              = " + System.getProperty("os.arch"));
        System.out.println("##########################################");
        LBCORE97.usingSynchronized(THREAD_COUNT);
        LBCORE97.usingUnfairLock(THREAD_COUNT);
        LBCORE97.usingFairLock(THREAD_COUNT);
    }

    public static void execute(String string, Thread[] threadArray) throws InterruptedException {
        int n;
        System.out.println("About to execute " + string + "...");
        int n2 = threadArray.length;
        for (n = 0; n < n2; ++n) {
            threadArray[n].start();
        }
        Thread.sleep(10000L);
        for (n = 0; n < n2; ++n) {
            threadArray[n].interrupt();
        }
        Thread.sleep(1000L);
    }

    public static void print(String string, Runnable[] runnableArray) {
        System.out.println("Results for " + string + ":");
        for (int i = 0; i < runnableArray.length; ++i) {
            System.out.println("runnables[" + i + "]: " + runnableArray[i]);
        }
        System.out.println("##########################################");
    }

    public static void usingSynchronized(int n) throws InterruptedException {
        Object object = new Object();
        Runnable[] runnableArray = new Runnable[n];
        Thread[] threadArray = new Thread[n];
        for (int i = 0; i < n; ++i) {
            runnableArray[i] = new SynchronizedRunnable(object);
            threadArray[i] = new Thread(runnableArray[i]);
        }
        String string = "usingSynchronized";
        LBCORE97.execute(string, threadArray);
        LBCORE97.print(string, runnableArray);
    }

    public static void usingUnfairLock(int n) throws InterruptedException {
        ReentrantLock reentrantLock = new ReentrantLock();
        Runnable[] runnableArray = new Runnable[n];
        Thread[] threadArray = new Thread[n];
        for (int i = 0; i < n; ++i) {
            runnableArray[i] = new LockRunnable(reentrantLock);
            threadArray[i] = new Thread(runnableArray[i]);
        }
        String string = "usingUnfairLock";
        LBCORE97.execute(string, threadArray);
        LBCORE97.print(string, runnableArray);
    }

    public static void usingFairLock(int n) throws InterruptedException {
        ReentrantLock reentrantLock = new ReentrantLock(true);
        Runnable[] runnableArray = new Runnable[n];
        Thread[] threadArray = new Thread[n];
        for (int i = 0; i < n; ++i) {
            runnableArray[i] = new LockRunnable(reentrantLock);
            threadArray[i] = new Thread(runnableArray[i]);
        }
        String string = "usingFairLock";
        LBCORE97.execute(string, threadArray);
        LBCORE97.print(string, runnableArray);
    }

    public static class LockRunnable
    implements Runnable {
        private final Lock lock;
        private int counter;
        private boolean running;

        public LockRunnable(Lock lock) {
            this.lock = lock;
            this.counter = 0;
            this.running = false;
        }

        public void run() {
            this.running = true;
            while (true) {
                this.lock.lock();
                try {
                    ++this.counter;
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
            this.running = false;
        }

        public String toString() {
            return "LockRunnable[counter=" + this.counter + ", running=" + this.running + "]";
        }
    }

    public static class SynchronizedRunnable
    implements Runnable {
        private final Object lockObject;
        private int counter;
        private boolean running;

        public SynchronizedRunnable(Object object) {
            this.lockObject = object;
            this.counter = 0;
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            while (true) {
                Object object = this.lockObject;
                synchronized (object) {
                    ++this.counter;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            this.running = false;
        }

        public String toString() {
            return "SynchronizedRunnable[counter=" + this.counter + ", running=" + this.running + "]";
        }
    }
}

