/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.issue.lbcore258;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FileLockSimulator {
    static String LINE_SEPARATOR = System.getProperty("line.separator");
    static final int DOT_FREQ = 128;
    static final int DOT_WITH_NEW_LINE_FREQ = 10240;
    static String instanceName;
    static int delay;
    static FileOutputStream fos;
    static FileChannel fileChannel;

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        String string = stringArray[0];
        System.out.println("Instance named as [" + string + "]");
        String string2 = stringArray[1];
        System.out.println("Output target specified as [" + string2 + "]");
        int n = Integer.parseInt(stringArray[2]);
        System.out.println("Sleep delay specified as [" + n + "] milliseconds");
        fos = new FileOutputStream(string2, true);
        fileChannel = fos.getChannel();
        int n2 = 1;
        while (true) {
            FileLockSimulator.printDotAndSleep(n2);
            FileLockSimulator.lockAndWrite(n2);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lockAndWrite(int n) throws InterruptedException, IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock();
            long l = fileChannel.position();
            long l2 = fileChannel.size();
            if (l2 != l) {
                fileChannel.position(l2);
            }
            String string = "hello from" + instanceName + " " + n + LINE_SEPARATOR;
            fos.write(string.getBytes());
        }
        finally {
            if (fileLock != null) {
                fileLock.release();
            }
        }
    }

    static void printDotAndSleep(int n) throws InterruptedException {
        if (n % 128 == 0) {
            System.out.print(".");
            Thread.sleep(delay);
        }
        if (n % 10240 == 0) {
            System.out.println("");
        }
    }
}

