/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.action.ext.BadBeginAction;
import ch.qos.logback.core.joran.action.ext.BadEndAction;
import ch.qos.logback.core.joran.action.ext.HelloAction;
import ch.qos.logback.core.joran.action.ext.TouchAction;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkippingInInterpreterTest {
    HashMap<ElementSelector, Action> rulesMap = new HashMap();
    Context context = new ContextBase();
    StatusManager sm = this.context.getStatusManager();

    SAXParser createParser() throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        return sAXParserFactory.newSAXParser();
    }

    void doTest(String string, Integer n, Class<?> clazz) throws Exception {
        this.rulesMap.put(new ElementSelector("test"), (Action)new NOPAction());
        this.rulesMap.put(new ElementSelector("test/badBegin"), new BadBeginAction());
        this.rulesMap.put(new ElementSelector("test/badBegin/touch"), new TouchAction());
        this.rulesMap.put(new ElementSelector("test/badEnd"), new BadEndAction());
        this.rulesMap.put(new ElementSelector("test/badEnd/touch"), new TouchAction());
        this.rulesMap.put(new ElementSelector("test/hello"), new HelloAction());
        this.rulesMap.put(new ElementSelector("test/isolate"), (Action)new NOPAction());
        this.rulesMap.put(new ElementSelector("test/isolate/badEnd"), new BadEndAction());
        this.rulesMap.put(new ElementSelector("test/isolate/badEnd/touch"), new TouchAction());
        this.rulesMap.put(new ElementSelector("test/isolate/touch"), new TouchAction());
        this.rulesMap.put(new ElementSelector("test/hello"), new HelloAction());
        TrivialConfigurator trivialConfigurator = new TrivialConfigurator(this.rulesMap);
        trivialConfigurator.setContext(this.context);
        trivialConfigurator.doConfigure("src/test/input/joran/skip/" + string);
        String string2 = this.context.getProperty("name");
        Assert.assertEquals((String)"Hello John Doe.", (String)string2);
        Integer n2 = (Integer)this.context.getObject("touched");
        if (n == null) {
            Assert.assertNull((Object)n2);
        } else {
            Assert.assertEquals((Object)n, (Object)n2);
        }
        List list = this.sm.getCopyOfStatusList();
        Status status = (Status)list.get(0);
        Assert.assertEquals((int)2, (int)status.getLevel());
        Assert.assertTrue((status.getThrowable().getClass() == clazz ? 1 : 0) != 0);
    }

    @Test
    public void testSkippingRuntimeExInBadBegin() throws Exception {
        this.doTest("badBegin1.xml", null, IllegalStateException.class);
    }

    @Test
    public void testSkippingActionExInBadBegin() throws Exception {
        this.doTest("badBegin2.xml", null, ActionException.class);
    }

    @Test
    public void testSkippingRuntimeExInBadEnd() throws Exception {
        this.doTest("badEnd1.xml", new Integer(2), IllegalStateException.class);
    }

    @Test
    public void testSkippingActionExInBadEnd() throws Exception {
        this.doTest("badEnd2.xml", new Integer(2), ActionException.class);
    }
}

