/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ext.IncAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.TrivialStatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TrivialConfiguratorTest {
    Context context = new ContextBase();
    HashMap<ElementSelector, Action> rulesMap = new HashMap();

    public void doTest(String string) throws Exception {
        this.rulesMap.put(new ElementSelector("x/inc"), new IncAction());
        TrivialConfigurator trivialConfigurator = new TrivialConfigurator(this.rulesMap);
        trivialConfigurator.setContext(this.context);
        trivialConfigurator.doConfigure(string);
    }

    @Test
    public void smoke() throws Exception {
        int n = IncAction.beginCount;
        int n2 = IncAction.endCount;
        int n3 = IncAction.errorCount;
        this.doTest("src/test/input/joran/inc.xml");
        Assert.assertEquals((int)n3, (int)IncAction.errorCount);
        Assert.assertEquals((int)(n + 1), (int)IncAction.beginCount);
        Assert.assertEquals((int)(n2 + 1), (int)IncAction.endCount);
    }

    @Test
    public void nonexistentFile() {
        TrivialStatusListener trivialStatusListener = new TrivialStatusListener();
        trivialStatusListener.start();
        String string = "src/test/input/joran/nothereBLAH.xml";
        this.context.getStatusManager().add((StatusListener)trivialStatusListener);
        try {
            this.doTest(string);
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)exception.getMessage().startsWith("Could not open ["));
        }
        Assert.assertTrue((String)(trivialStatusListener.list.size() + " should be greater than or equal to 1"), (trivialStatusListener.list.size() >= 1 ? 1 : 0) != 0);
        Status status = trivialStatusListener.list.get(0);
        Assert.assertTrue((boolean)status.getMessage().startsWith("Could not open ["));
    }

    @Test
    public void illFormedXML() {
        TrivialStatusListener trivialStatusListener = new TrivialStatusListener();
        trivialStatusListener.start();
        String string = "src/test/input/joran/illformed.xml";
        this.context.getStatusManager().add((StatusListener)trivialStatusListener);
        try {
            this.doTest(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertTrue((trivialStatusListener.list.size() >= 1 ? 1 : 0) != 0);
        Status status = trivialStatusListener.list.get(0);
        Assert.assertTrue((boolean)status.getMessage().startsWith("XML_PARSING"));
    }

    @Test
    public void lbcore105() throws IOException, JoranException {
        String string = "buzz.xml";
        File file = this.makeRandomJarFile();
        this.fillInJarFile(file, string);
        URL uRL = this.asURL(file, string);
        TrivialConfigurator trivialConfigurator = new TrivialConfigurator(this.rulesMap);
        trivialConfigurator.setContext(this.context);
        trivialConfigurator.doConfigure(uRL);
        Assert.assertTrue((boolean)file.delete());
        Assert.assertFalse((boolean)file.exists());
    }

    @Test
    public void lbcore127() throws IOException, JoranException {
        String string = "buzz.xml";
        String string2 = "lightyear.xml";
        File file = this.makeRandomJarFile();
        this.fillInJarFile(file, string, string2);
        URL uRL = this.asURL(file, string);
        URL uRL2 = this.asURL(file, string2);
        URLConnection uRLConnection = uRL2.openConnection();
        uRLConnection.setUseCaches(false);
        InputStream inputStream = uRLConnection.getInputStream();
        TrivialConfigurator trivialConfigurator = new TrivialConfigurator(this.rulesMap);
        trivialConfigurator.setContext(this.context);
        trivialConfigurator.doConfigure(uRL);
        inputStream.read();
        inputStream.close();
        Assert.assertTrue((boolean)file.delete());
        Assert.assertFalse((boolean)file.exists());
    }

    File makeRandomJarFile() {
        File file = new File("target/test-output/");
        file.mkdirs();
        int n = RandomUtil.getPositiveInt();
        return new File("target/test-output/foo-" + n + ".jar");
    }

    private void fillInJarFile(File file, String string) throws IOException {
        this.fillInJarFile(file, string, null);
    }

    private void fillInJarFile(File file, String string, String string2) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
        jarOutputStream.putNextEntry(new ZipEntry(string));
        jarOutputStream.write("<x/>".getBytes());
        jarOutputStream.closeEntry();
        if (string2 != null) {
            jarOutputStream.putNextEntry(new ZipEntry(string2));
            jarOutputStream.write("<y/>".getBytes());
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
    }

    URL asURL(File file, String string) throws IOException {
        URL uRL = file.toURI().toURL();
        return new URL("jar:" + uRL + "!/" + string);
    }

    @Test
    public void closesInputStreamAfterward() throws IOException, JoranException {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        TrivialConfigurator trivialConfigurator = new TrivialConfigurator(this.rulesMap);
        trivialConfigurator.setContext(this.context);
        try {
            trivialConfigurator.doConfigure(inputStream);
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }
}

