/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxEventRecorderTest {
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);

    SAXParser createParser() throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        return sAXParserFactory.newSAXParser();
    }

    public List<SaxEvent> doTest(String string) throws Exception {
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        FileInputStream fileInputStream = new FileInputStream("src/test/input/joran/" + string);
        saxEventRecorder.recordEvents((InputStream)fileInputStream);
        return saxEventRecorder.getSaxEventList();
    }

    public void dump(List<SaxEvent> list) {
        for (SaxEvent saxEvent : list) {
            System.out.println(saxEvent);
        }
    }

    @Test
    public void test1() throws Exception {
        List<SaxEvent> list = this.doTest("event1.xml");
        Assert.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)11, (int)list.size());
    }

    @Test
    public void test2() throws Exception {
        List<SaxEvent> list = this.doTest("ampEvent.xml");
        StatusManager statusManager = this.context.getStatusManager();
        Assert.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)3, (int)list.size());
        BodyEvent bodyEvent = (BodyEvent)list.get(1);
        Assert.assertEquals((String)"xxx & yyy", (String)bodyEvent.getText());
    }

    @Test
    public void test3() throws Exception {
        List<SaxEvent> list = this.doTest("inc.xml");
        StatusManager statusManager = this.context.getStatusManager();
        Assert.assertTrue((this.statusChecker.getHighestLevel(0L) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)4, (int)list.size());
        StartEvent startEvent = (StartEvent)list.get(1);
        Attributes attributes = startEvent.getAttributes();
        Assert.assertNotNull((Object)attributes);
        Assert.assertEquals((String)"1", (String)attributes.getValue("increment"));
    }

    @Test
    public void bodyWithSpacesAndQuotes() throws Exception {
        List<SaxEvent> list = this.doTest("spacesAndQuotes.xml");
        Assert.assertEquals((int)3, (int)list.size());
        BodyEvent bodyEvent = (BodyEvent)list.get(1);
        Assert.assertEquals((String)"[x][x] \"xyz\"%n", (String)bodyEvent.getText());
    }
}

