/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.implicitAction;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.SimpleConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.implicitAction.Cake;
import ch.qos.logback.core.joran.implicitAction.Fruit;
import ch.qos.logback.core.joran.implicitAction.FruitContext;
import ch.qos.logback.core.joran.implicitAction.FruitContextAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImplicitActionTest {
    static final String IMPLCIT_DIR = "src/test/input/joran/implicitAction/";
    FruitContext fruitContext = new FruitContext();
    SimpleConfigurator simpleConfigurator;

    @Before
    public void setUp() throws Exception {
        this.fruitContext.setName("fruits");
        HashMap<ElementSelector, Action> hashMap = new HashMap<ElementSelector, Action>();
        hashMap.put(new ElementSelector("/context/"), new FruitContextAction());
        this.simpleConfigurator = new SimpleConfigurator(hashMap);
        this.simpleConfigurator.setContext((Context)this.fruitContext);
    }

    void verifyFruit() {
        List<Fruit> list = this.fruitContext.getFruitList();
        Assert.assertNotNull(list);
        Assert.assertEquals((int)1, (int)list.size());
        Fruit fruit = list.get(0);
        Assert.assertEquals((String)"blue", (String)fruit.getName());
        Assert.assertEquals((int)2, (int)fruit.textList.size());
        Assert.assertEquals((String)"hello", (String)fruit.textList.get(0));
        Assert.assertEquals((String)"world", (String)fruit.textList.get(1));
    }

    @Test
    public void nestedComplex() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplex.xml");
            this.verifyFruit();
        }
        catch (Exception exception) {
            StatusPrinter.print((Context)this.fruitContext);
            throw exception;
        }
    }

    @Test
    public void nestedComplexWithoutClassAtrribute() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplexWithoutClassAtrribute.xml");
            this.verifyFruit();
        }
        catch (Exception exception) {
            StatusPrinter.print((Context)this.fruitContext);
            throw exception;
        }
    }

    void verifyFruitList() {
        List<Fruit> list = this.fruitContext.getFruitList();
        Assert.assertNotNull(list);
        Assert.assertEquals((int)1, (int)list.size());
        Fruit fruit = list.get(0);
        Assert.assertEquals((int)2, (int)fruit.cakeList.size());
        Cake cake = fruit.cakeList.get(0);
        Assert.assertEquals((String)"A", (String)cake.getType());
        Cake cake2 = fruit.cakeList.get(1);
        Assert.assertEquals((String)"B", (String)cake2.getType());
    }

    @Test
    public void nestedComplexCollection() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplexCollection.xml");
            this.verifyFruitList();
        }
        catch (Exception exception) {
            StatusPrinter.print((Context)this.fruitContext);
            throw exception;
        }
    }

    @Test
    public void nestedComplexCollectionWithoutClassAtrribute() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplexCollectionWithoutClassAtrribute.xml");
            this.verifyFruitList();
        }
        catch (Exception exception) {
            StatusPrinter.print((Context)this.fruitContext);
            throw exception;
        }
    }
}

