/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.replay;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.SimpleConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.replay.Fruit;
import ch.qos.logback.core.joran.replay.FruitContext;
import ch.qos.logback.core.joran.replay.FruitFactory;
import ch.qos.logback.core.joran.replay.FruitFactoryAction;
import ch.qos.logback.core.joran.replay.FruitShell;
import ch.qos.logback.core.joran.replay.FruitShellAction;
import ch.qos.logback.core.joran.replay.WeightytFruit;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FruitConfigurationTest {
    FruitContext fruitContext = new FruitContext();

    public List<FruitShell> doFirstPart(String string) throws Exception {
        try {
            HashMap<ElementSelector, Action> hashMap = new HashMap<ElementSelector, Action>();
            hashMap.put(new ElementSelector("group/fruitShell"), new FruitShellAction());
            hashMap.put(new ElementSelector("group/fruitShell/fruit"), new FruitFactoryAction());
            hashMap.put(new ElementSelector("group/fruitShell/fruit/*"), (Action)new NOPAction());
            SimpleConfigurator simpleConfigurator = new SimpleConfigurator(hashMap);
            simpleConfigurator.setContext((Context)this.fruitContext);
            simpleConfigurator.doConfigure("src/test/input/joran/replay/" + string);
            return this.fruitContext.getFruitShellList();
        }
        catch (Exception exception) {
            StatusPrinter.print((Context)this.fruitContext);
            throw exception;
        }
    }

    @Test
    public void fruit1() throws Exception {
        List<FruitShell> list = this.doFirstPart("fruit1.xml");
        Assert.assertNotNull(list);
        Assert.assertEquals((int)1, (int)list.size());
        FruitShell fruitShell = list.get(0);
        Assert.assertNotNull((Object)((Object)fruitShell));
        Assert.assertEquals((String)"fs0", (String)fruitShell.getName());
        Fruit fruit = fruitShell.fruitFactory.buildFruit();
        Assert.assertTrue((boolean)(fruit instanceof Fruit));
        Assert.assertEquals((String)"blue", (String)fruit.getName());
    }

    @Test
    public void fruit2() throws Exception {
        List<FruitShell> list = this.doFirstPart("fruit2.xml");
        Assert.assertNotNull(list);
        Assert.assertEquals((int)2, (int)list.size());
        FruitShell fruitShell = list.get(0);
        Assert.assertNotNull((Object)((Object)fruitShell));
        Assert.assertEquals((String)"fs0", (String)fruitShell.getName());
        Fruit fruit = fruitShell.fruitFactory.buildFruit();
        Assert.assertTrue((boolean)(fruit instanceof Fruit));
        Assert.assertEquals((String)"blue", (String)fruit.getName());
        FruitShell fruitShell2 = list.get(1);
        Assert.assertNotNull((Object)((Object)fruitShell2));
        Assert.assertEquals((String)"fs1", (String)fruitShell2.getName());
        Fruit fruit2 = fruitShell2.fruitFactory.buildFruit();
        Assert.assertTrue((boolean)(fruit2 instanceof WeightytFruit));
        Assert.assertEquals((String)"orange", (String)fruit2.getName());
        Assert.assertEquals((double)1.2, (double)((WeightytFruit)fruit2).getWeight(), (double)0.01);
    }

    @Test
    public void withSubst() throws Exception {
        List<FruitShell> list = this.doFirstPart("fruitWithSubst.xml");
        Assert.assertNotNull(list);
        Assert.assertEquals((int)1, (int)list.size());
        FruitShell fruitShell = list.get(0);
        Assert.assertNotNull((Object)((Object)fruitShell));
        Assert.assertEquals((String)"fs0", (String)fruitShell.getName());
        int n = FruitFactory.count;
        Fruit fruit = fruitShell.fruitFactory.buildFruit();
        Assert.assertTrue((boolean)(fruit instanceof WeightytFruit));
        Assert.assertEquals((String)("orange-" + n), (String)fruit.getName());
        Assert.assertEquals((double)1.2, (double)((WeightytFruit)fruit).getWeight(), (double)0.01);
    }
}

