/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.replay;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.replay.FruitContext;
import ch.qos.logback.core.joran.replay.FruitShell;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class FruitShellAction
extends Action {
    FruitShell fruitShell;
    private boolean inError = false;

    public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) throws ActionException {
        this.fruitShell = new FruitShell();
        this.inError = false;
        try {
            this.fruitShell.setContext(this.context);
            String string2 = attributes.getValue("name");
            if (OptionHelper.isEmpty((String)string2)) {
                this.addWarn("No appender name given for fruitShell].");
            } else {
                this.fruitShell.setName(string2);
                this.addInfo("FruitShell named as [" + string2 + "]");
            }
            interpretationContext.pushObject((Object)this.fruitShell);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create an FruitShell", exception);
            throw new ActionException((Throwable)exception);
        }
    }

    public void end(InterpretationContext interpretationContext, String string) throws ActionException {
        if (this.inError) {
            return;
        }
        Object object = interpretationContext.peekObject();
        if (object != this.fruitShell) {
            this.addWarn("The object at the of the stack is not the fruitShell named [" + this.fruitShell.getName() + "] pushed earlier.");
        } else {
            this.addInfo("Popping fruitSHell named [" + this.fruitShell.getName() + "] from the object stack");
            interpretationContext.popObject();
            FruitContext fruitContext = (FruitContext)interpretationContext.getContext();
            fruitContext.addFruitShell(this.fruitShell);
        }
    }
}

