/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.ElementSelector;
import org.junit.Assert;
import org.junit.Test;

public class ElementSelectorTest {
    @Test
    public void test1() {
        ElementSelector elementSelector = new ElementSelector("a");
        Assert.assertEquals((long)1L, (long)elementSelector.size());
        Assert.assertEquals((Object)"a", (Object)elementSelector.peekLast());
        Assert.assertEquals((Object)"a", (Object)elementSelector.get(0));
    }

    @Test
    public void testSuffix() {
        ElementSelector elementSelector = new ElementSelector("a/");
        Assert.assertEquals((long)1L, (long)elementSelector.size());
        Assert.assertEquals((Object)"a", (Object)elementSelector.peekLast());
        Assert.assertEquals((Object)"a", (Object)elementSelector.get(0));
    }

    @Test
    public void test2() {
        ElementSelector elementSelector = new ElementSelector("a/b");
        Assert.assertEquals((long)2L, (long)elementSelector.size());
        Assert.assertEquals((Object)"b", (Object)elementSelector.peekLast());
        Assert.assertEquals((Object)"a", (Object)elementSelector.get(0));
        Assert.assertEquals((Object)"b", (Object)elementSelector.get(1));
    }

    @Test
    public void test3() {
        ElementSelector elementSelector = new ElementSelector("a123/b1234/cvvsdf");
        Assert.assertEquals((long)3L, (long)elementSelector.size());
        Assert.assertEquals((Object)"a123", (Object)elementSelector.get(0));
        Assert.assertEquals((Object)"b1234", (Object)elementSelector.get(1));
        Assert.assertEquals((Object)"cvvsdf", (Object)elementSelector.get(2));
    }

    @Test
    public void test4() {
        ElementSelector elementSelector = new ElementSelector("/a123/b1234/cvvsdf");
        Assert.assertEquals((long)3L, (long)elementSelector.size());
        Assert.assertEquals((Object)"a123", (Object)elementSelector.get(0));
        Assert.assertEquals((Object)"b1234", (Object)elementSelector.get(1));
        Assert.assertEquals((Object)"cvvsdf", (Object)elementSelector.get(2));
    }

    @Test
    public void test5() {
        ElementSelector elementSelector = new ElementSelector("//a");
        Assert.assertEquals((long)1L, (long)elementSelector.size());
        Assert.assertEquals((Object)"a", (Object)elementSelector.get(0));
    }

    @Test
    public void test6() {
        ElementSelector elementSelector = new ElementSelector("//a//b");
        Assert.assertEquals((long)2L, (long)elementSelector.size());
        Assert.assertEquals((Object)"a", (Object)elementSelector.get(0));
        Assert.assertEquals((Object)"b", (Object)elementSelector.get(1));
    }

    @Test
    public void testTailMatch() {
        ElementPath elementPath = new ElementPath("/a/b");
        ElementSelector elementSelector = new ElementSelector("*");
        Assert.assertEquals((long)0L, (long)elementSelector.getTailMatchLength(elementPath));
        elementPath = new ElementPath("/a");
        elementSelector = new ElementSelector("*/a");
        Assert.assertEquals((long)1L, (long)elementSelector.getTailMatchLength(elementPath));
        elementPath = new ElementPath("/A");
        elementSelector = new ElementSelector("*/a");
        Assert.assertEquals((long)1L, (long)elementSelector.getTailMatchLength(elementPath));
        elementPath = new ElementPath("/a");
        elementSelector = new ElementSelector("*/A");
        Assert.assertEquals((long)1L, (long)elementSelector.getTailMatchLength(elementPath));
        elementPath = new ElementPath("/a/b");
        elementSelector = new ElementSelector("*/b");
        Assert.assertEquals((long)1L, (long)elementSelector.getTailMatchLength(elementPath));
        elementPath = new ElementPath("/a/B");
        elementSelector = new ElementSelector("*/b");
        Assert.assertEquals((long)1L, (long)elementSelector.getTailMatchLength(elementPath));
        elementPath = new ElementPath("/a/b/c");
        elementSelector = new ElementSelector("*/b/c");
        Assert.assertEquals((long)2L, (long)elementSelector.getTailMatchLength(elementPath));
    }

    @Test
    public void testPrefixMatch() {
        ElementPath elementPath = new ElementPath("/a/b");
        ElementSelector elementSelector = new ElementSelector("/x/*");
        Assert.assertEquals((long)0L, (long)elementSelector.getPrefixMatchLength(elementPath));
        elementPath = new ElementPath("/a");
        elementSelector = new ElementSelector("/x/*");
        Assert.assertEquals((long)0L, (long)elementSelector.getPrefixMatchLength(elementPath));
        elementPath = new ElementPath("/a/b");
        elementSelector = new ElementSelector("/a/*");
        Assert.assertEquals((long)1L, (long)elementSelector.getPrefixMatchLength(elementPath));
        elementPath = new ElementPath("/a/b");
        elementSelector = new ElementSelector("/A/*");
        Assert.assertEquals((long)1L, (long)elementSelector.getPrefixMatchLength(elementPath));
        elementPath = new ElementPath("/A/b");
        elementSelector = new ElementSelector("/a/*");
        Assert.assertEquals((long)1L, (long)elementSelector.getPrefixMatchLength(elementPath));
        elementPath = new ElementPath("/a/b");
        elementSelector = new ElementSelector("/a/b/*");
        Assert.assertEquals((long)2L, (long)elementSelector.getPrefixMatchLength(elementPath));
        elementPath = new ElementPath("/a/b");
        elementSelector = new ElementSelector("/*");
        Assert.assertEquals((long)0L, (long)elementSelector.getPrefixMatchLength(elementPath));
    }
}

