/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.CaseCombinator;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;

public class SimpleRuleStoreTest {
    SimpleRuleStore srs = new SimpleRuleStore((Context)new ContextBase());
    CaseCombinator cc = new CaseCombinator();

    @Test
    public void smoke() throws Exception {
        this.srs.addRule(new ElementSelector("a/b"), (Action)new XAction());
        for (String string : this.cc.combinations("a/b")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((int)1, (int)list.size());
            if (list.get(0) instanceof XAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void smokeII() throws Exception {
        this.srs.addRule(new ElementSelector("a/b"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("a/b"), (Action)new YAction());
        for (String string : this.cc.combinations("a/b")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((int)2, (int)list.size());
            if (!(list.get(0) instanceof XAction)) {
                Assert.fail((String)"Wrong type");
            }
            if (list.get(1) instanceof YAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testSlashSuffix() throws Exception {
        ElementSelector elementSelector = new ElementSelector("a/");
        this.srs.addRule(elementSelector, (Action)new XAction());
        for (String string : this.cc.combinations("a")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((int)1, (int)list.size());
            if (list.get(0) instanceof XAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail1() throws Exception {
        this.srs.addRule(new ElementSelector("*/b"), (Action)new XAction());
        for (String string : this.cc.combinations("a/b")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((int)1, (int)list.size());
            if (list.get(0) instanceof XAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail2() throws Exception {
        SimpleRuleStore simpleRuleStore = new SimpleRuleStore((Context)new ContextBase());
        simpleRuleStore.addRule(new ElementSelector("*/c"), (Action)new XAction());
        for (String string : this.cc.combinations("a/b/c")) {
            List list = simpleRuleStore.matchActions(new ElementPath(string));
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((int)1, (int)list.size());
            if (list.get(0) instanceof XAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail3() throws Exception {
        this.srs.addRule(new ElementSelector("*/b"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("*/a/b"), (Action)new YAction());
        for (String string : this.cc.combinations("a/b")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((int)1, (int)list.size());
            if (list.get(0) instanceof YAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testTail4() throws Exception {
        this.srs.addRule(new ElementSelector("*/b"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("*/a/b"), (Action)new YAction());
        this.srs.addRule(new ElementSelector("a/b"), (Action)new ZAction());
        for (String string : this.cc.combinations("a/b")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((int)1, (int)list.size());
            if (list.get(0) instanceof ZAction) continue;
            Assert.fail((String)"Wrong type");
        }
    }

    @Test
    public void testSuffix() throws Exception {
        this.srs.addRule(new ElementSelector("a"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("a/*"), (Action)new YAction());
        for (String string : this.cc.combinations("a/b")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((int)1, (int)list.size());
            Assert.assertTrue((boolean)(list.get(0) instanceof YAction));
        }
    }

    @Test
    public void testDeepSuffix() throws Exception {
        this.srs.addRule(new ElementSelector("a"), (Action)new XAction(1));
        this.srs.addRule(new ElementSelector("a/b/*"), (Action)new XAction(2));
        for (String string : this.cc.combinations("a/other")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNull((Object)list);
        }
    }

    @Test
    public void testPrefixSuffixInteraction1() throws Exception {
        this.srs.addRule(new ElementSelector("a"), (Action)new ZAction());
        this.srs.addRule(new ElementSelector("a/*"), (Action)new YAction());
        this.srs.addRule(new ElementSelector("*/a/b"), (Action)new XAction(3));
        for (String string : this.cc.combinations("a/b")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((int)1, (int)list.size());
            Assert.assertTrue((boolean)(list.get(0) instanceof XAction));
            XAction xAction = (XAction)((Object)list.get(0));
            Assert.assertEquals((int)3, (int)xAction.id);
        }
    }

    @Test
    public void testPrefixSuffixInteraction2() throws Exception {
        this.srs.addRule(new ElementSelector("tG"), (Action)new XAction());
        this.srs.addRule(new ElementSelector("tG/tS"), (Action)new YAction());
        this.srs.addRule(new ElementSelector("tG/tS/test"), (Action)new ZAction());
        this.srs.addRule(new ElementSelector("tG/tS/test/*"), (Action)new XAction(9));
        for (String string : this.cc.combinations("tG/tS/toto")) {
            List list = this.srs.matchActions(new ElementPath(string));
            Assert.assertNull((Object)list);
        }
    }

    class ZAction
    extends Action {
        ZAction() {
        }

        public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        }

        public void end(InterpretationContext interpretationContext, String string) {
        }

        public void finish(InterpretationContext interpretationContext) {
        }
    }

    class YAction
    extends Action {
        YAction() {
        }

        public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        }

        public void end(InterpretationContext interpretationContext, String string) {
        }

        public void finish(InterpretationContext interpretationContext) {
        }
    }

    class XAction
    extends Action {
        int id = 0;

        XAction() {
        }

        XAction(int n) {
            this.id = n;
        }

        public void begin(InterpretationContext interpretationContext, String string, Attributes attributes) {
        }

        public void end(InterpretationContext interpretationContext, String string) {
        }

        public void finish(InterpretationContext interpretationContext) {
        }

        public String toString() {
            return "XAction(" + this.id + ")";
        }
    }
}

