/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.Door;
import ch.qos.logback.core.joran.util.House;
import ch.qos.logback.core.joran.util.HouseColor;
import ch.qos.logback.core.joran.util.LargeSwimmingPoolImpl;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.joran.util.SwimmingPoolImpl;
import ch.qos.logback.core.joran.util.Window;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.util.AggregationType;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertySetterTest {
    DefaultNestedComponentRegistry defaultComponentRegistry = new DefaultNestedComponentRegistry();
    Context context = new ContextBase();
    House house = new House();
    PropertySetter setter = new PropertySetter((Object)this.house);

    @Before
    public void setUp() {
        this.setter.setContext(this.context);
    }

    @Test
    public void testCanAggregateComponent() {
        Assert.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY, (Object)this.setter.computeAggregationType("door"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("count"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Count"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("name"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Name"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Duration"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("fs"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("open"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("Open"));
        Assert.assertEquals((Object)AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, (Object)this.setter.computeAggregationType("Window"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY_COLLECTION, (Object)this.setter.computeAggregationType("adjective"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("filterReply"));
        Assert.assertEquals((Object)AggregationType.AS_BASIC_PROPERTY, (Object)this.setter.computeAggregationType("houseColor"));
        System.out.println();
    }

    @Test
    public void testSetProperty() {
        House house = new House();
        PropertySetter propertySetter = new PropertySetter((Object)house);
        propertySetter.setProperty("count", "10");
        propertySetter.setProperty("temperature", "33.1");
        propertySetter.setProperty("name", "jack");
        propertySetter.setProperty("open", "true");
        Assert.assertEquals((int)10, (int)house.getCount());
        Assert.assertEquals((double)33.1, (double)house.getTemperature(), (double)0.01);
        Assert.assertEquals((String)"jack", (String)house.getName());
        Assert.assertTrue((boolean)house.isOpen());
        house = new House();
        propertySetter = new PropertySetter((Object)house);
        propertySetter.setProperty("Count", "10");
        propertySetter.setProperty("Name", "jack");
        propertySetter.setProperty("Open", "true");
        Assert.assertEquals((int)10, (int)house.getCount());
        Assert.assertEquals((String)"jack", (String)house.getName());
        Assert.assertTrue((boolean)house.isOpen());
    }

    @Test
    public void testSetCamelProperty() {
        this.setter.setProperty("camelCase", "trot");
        Assert.assertEquals((String)"trot", (String)this.house.getCamelCase());
        this.setter.setProperty("camelCase", "gh");
        Assert.assertEquals((String)"gh", (String)this.house.getCamelCase());
    }

    @Test
    public void testSetComplexProperty() {
        Door door = new Door();
        this.setter.setComplexProperty("door", (Object)door);
        Assert.assertEquals((Object)door, (Object)this.house.getDoor());
    }

    @Test
    public void testgetClassNameViaImplicitRules() {
        Class clazz = this.setter.getClassNameViaImplicitRules("door", AggregationType.AS_COMPLEX_PROPERTY, this.defaultComponentRegistry);
        Assert.assertEquals(Door.class, (Object)clazz);
    }

    @Test
    public void testgetComplexPropertyColleClassNameViaImplicitRules() {
        Class clazz = this.setter.getClassNameViaImplicitRules("window", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, this.defaultComponentRegistry);
        Assert.assertEquals(Window.class, (Object)clazz);
    }

    @Test
    public void testPropertyCollection() {
        this.setter.addBasicProperty("adjective", "nice");
        this.setter.addBasicProperty("adjective", "big");
        Assert.assertEquals((int)2, (int)this.house.adjectiveList.size());
        Assert.assertEquals((String)"nice", (String)this.house.adjectiveList.get(0));
        Assert.assertEquals((String)"big", (String)this.house.adjectiveList.get(1));
    }

    @Test
    public void testComplexCollection() {
        Window window = new Window();
        window.handle = 10;
        Window window2 = new Window();
        window2.handle = 20;
        this.setter.addComplexProperty("window", (Object)window);
        this.setter.addComplexProperty("window", (Object)window2);
        Assert.assertEquals((int)2, (int)this.house.windowList.size());
        Assert.assertEquals((int)10, (int)this.house.windowList.get((int)0).handle);
        Assert.assertEquals((int)20, (int)this.house.windowList.get((int)1).handle);
    }

    @Test
    public void testSetComplexWithCamelCaseName() {
        SwimmingPoolImpl swimmingPoolImpl = new SwimmingPoolImpl();
        this.setter.setComplexProperty("swimmingPool", (Object)swimmingPoolImpl);
        Assert.assertEquals((Object)swimmingPoolImpl, (Object)this.house.getSwimmingPool());
    }

    @Test
    public void testDuration() {
        this.setter.setProperty("duration", "1.4 seconds");
        Assert.assertEquals((long)1400L, (long)this.house.getDuration().getMilliseconds());
    }

    @Test
    public void testFileSize() {
        this.setter.setProperty("fs", "2 kb");
        Assert.assertEquals((long)2048L, (long)this.house.getFs().getSize());
    }

    @Test
    public void testFilterReply() {
        this.setter.setProperty("filterReply", "ACCEPT");
        Assert.assertEquals((Object)FilterReply.ACCEPT, (Object)this.house.getFilterReply());
    }

    @Test
    public void testEnum() {
        this.setter.setProperty("houseColor", "BLUE");
        Assert.assertEquals((Object)((Object)HouseColor.BLUE), (Object)((Object)this.house.getHouseColor()));
    }

    @Test
    public void testDefaultClassAnnonation() {
        Method method = this.setter.getRelevantMethod("SwimmingPool", AggregationType.AS_COMPLEX_PROPERTY);
        Assert.assertNotNull((Object)method);
        Class clazz = this.setter.getDefaultClassNameByAnnonation("SwimmingPool", method);
        Assert.assertEquals(SwimmingPoolImpl.class, (Object)clazz);
        Class clazz2 = this.setter.getClassNameViaImplicitRules("SwimmingPool", AggregationType.AS_COMPLEX_PROPERTY, this.defaultComponentRegistry);
        Assert.assertEquals(SwimmingPoolImpl.class, (Object)clazz2);
    }

    @Test
    public void testDefaultClassAnnotationForLists() {
        Method method = this.setter.getRelevantMethod("LargeSwimmingPool", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION);
        Assert.assertNotNull((Object)method);
        Class clazz = this.setter.getDefaultClassNameByAnnonation("LargeSwimmingPool", method);
        Assert.assertEquals(LargeSwimmingPoolImpl.class, (Object)clazz);
        Class clazz2 = this.setter.getClassNameViaImplicitRules("LargeSwimmingPool", AggregationType.AS_COMPLEX_PROPERTY_COLLECTION, this.defaultComponentRegistry);
        Assert.assertEquals(LargeSwimmingPoolImpl.class, (Object)clazz2);
    }

    @Test
    public void charset() {
        this.setter.setProperty("charset", "UTF-8");
        Assert.assertEquals((Object)Charset.forName("UTF-8"), (Object)this.house.getCharset());
        this.house.setCharset(null);
        this.setter.setProperty("charset", "UTF");
        Assert.assertNull((Object)this.house.getCharset());
        StatusChecker statusChecker = new StatusChecker(this.context);
        statusChecker.containsException(UnsupportedCharsetException.class);
    }
}

