/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.net.server.ServerSocketUtil;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultSocketConnectorTest {
    private static final int DELAY = 1000;
    private static final int SHORT_DELAY = 10;
    private static final int RETRY_DELAY = 10;
    private MockExceptionHandler exceptionHandler = new MockExceptionHandler();
    private ServerSocket serverSocket;
    private DefaultSocketConnector connector;
    ExecutorService executor = Executors.newSingleThreadExecutor();

    @Before
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        this.connector = new DefaultSocketConnector(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort(), 0L, 10L);
        this.connector.setExceptionHandler((SocketConnector.ExceptionHandler)this.exceptionHandler);
    }

    @After
    public void tearDown() throws Exception {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    @Test
    public void testConnect() throws Exception {
        Future future = this.executor.submit(this.connector);
        Socket socket = (Socket)future.get(2000L, TimeUnit.MILLISECONDS);
        junit.framework.Assert.assertNotNull((Object)socket);
        future.cancel(true);
        Assert.assertTrue((boolean)future.isDone());
        socket.close();
    }

    @Test
    public void testConnectionFails() throws Exception {
        this.serverSocket.close();
        Future future = this.executor.submit(this.connector);
        try {
            future.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Exception exception = this.exceptionHandler.awaitConnectionFailed(1000L);
        Assert.assertTrue((boolean)(exception instanceof ConnectException));
        Assert.assertFalse((boolean)future.isDone());
        future.cancel(true);
        Assert.assertTrue((boolean)future.isCancelled());
    }

    @Test(timeout=5000L)
    public void testConnectEventually() throws Exception {
        this.serverSocket.close();
        Future future = this.executor.submit(this.connector);
        try {
            future.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Exception exception = this.exceptionHandler.awaitConnectionFailed(1000L);
        junit.framework.Assert.assertNotNull((Object)exception);
        Assert.assertTrue((boolean)(exception instanceof ConnectException));
        SocketAddress socketAddress = this.serverSocket.getLocalSocketAddress();
        this.serverSocket = new ServerSocket();
        this.serverSocket.setReuseAddress(true);
        this.serverSocket.bind(socketAddress);
        Socket socket = (Socket)future.get(2000L, TimeUnit.MILLISECONDS);
        junit.framework.Assert.assertNotNull((Object)socket);
        Assert.assertFalse((boolean)future.isCancelled());
        socket.close();
    }

    private static class MockExceptionHandler
    implements SocketConnector.ExceptionHandler {
        private final Lock lock = new ReentrantLock();
        private final Condition failedCondition = this.lock.newCondition();
        private Exception lastException;

        private MockExceptionHandler() {
        }

        public void connectionFailed(SocketConnector socketConnector, Exception exception) {
            this.lastException = exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception awaitConnectionFailed(long l) throws InterruptedException {
            this.lock.lock();
            try {
                long l2 = 10L;
                while (this.lastException == null && l > 0L) {
                    boolean bl = this.failedCondition.await(l2, TimeUnit.MILLISECONDS);
                    l -= l2;
                    if (!bl) continue;
                    break;
                }
                Exception exception = this.lastException;
                return exception;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

