/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.net.SocketConnectorBase;
import ch.qos.logback.core.net.server.ServerSocketUtil;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SocketConnectorBaseTest {
    private static final int DELAY = 1000;
    private MockExceptionHandler exceptionHandler = new MockExceptionHandler();
    private ServerSocket serverSocket;
    private SocketConnectorBase connector;

    @Before
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        this.connector = new SocketConnectorBase(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort(), 0, 1000);
        this.connector.setExceptionHandler((SocketConnector.ExceptionHandler)this.exceptionHandler);
    }

    @After
    public void tearDown() throws Exception {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    @Test
    public void testConnect() throws Exception {
        Thread thread = new Thread();
        thread.start();
        Socket socket = this.connector.awaitConnection(2000L);
        Assert.assertNotNull((Object)socket);
        thread.join(1000L);
        Assert.assertFalse((boolean)thread.isAlive());
        socket.close();
    }

    @Test
    public void testConnectionFails() throws Exception {
        this.serverSocket.close();
        Thread thread = new Thread();
        thread.start();
        Socket socket = this.connector.awaitConnection(2000L);
        Assert.assertNull((Object)socket);
        Exception exception = this.exceptionHandler.awaitConnectionFailed(1000L);
        Assert.assertTrue((boolean)(exception instanceof ConnectException));
        Assert.assertTrue((boolean)thread.isAlive());
        thread.interrupt();
        thread.join(4000L);
        Assert.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testConnectEventually() throws Exception {
        this.serverSocket.close();
        Thread thread = new Thread();
        thread.start();
        Socket socket = this.connector.awaitConnection(2000L);
        Assert.assertNull((Object)socket);
        Exception exception = this.exceptionHandler.awaitConnectionFailed(1000L);
        Assert.assertTrue((boolean)(exception instanceof ConnectException));
        Assert.assertTrue((boolean)thread.isAlive());
        SocketAddress socketAddress = this.serverSocket.getLocalSocketAddress();
        this.serverSocket = new ServerSocket();
        this.serverSocket.setReuseAddress(true);
        this.serverSocket.bind(socketAddress);
        socket = this.connector.awaitConnection(2000L);
        Assert.assertNotNull((Object)socket);
        thread.join(1000L);
        Assert.assertFalse((boolean)thread.isAlive());
        socket.close();
    }

    private static class MockExceptionHandler
    implements SocketConnector.ExceptionHandler {
        private final Lock lock = new ReentrantLock();
        private final Condition failedCondition = this.lock.newCondition();
        private Exception lastException;

        private MockExceptionHandler() {
        }

        public void connectionFailed(SocketConnector socketConnector, Exception exception) {
            this.lastException = exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception awaitConnectionFailed(long l) throws InterruptedException {
            this.lock.lock();
            try {
                boolean bl = false;
                while (this.lastException == null && !bl) {
                    bl = !this.failedCondition.await(l, TimeUnit.MILLISECONDS);
                }
                Exception exception = this.lastException;
                return exception;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

