/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.Client;
import ch.qos.logback.core.net.server.ServerListener;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServerListener<T extends Client>
implements ServerListener<T> {
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    private boolean closed;
    private Thread waiter;

    public synchronized Thread getWaiter() {
        return this.waiter;
    }

    public synchronized void setWaiter(Thread thread) {
        this.waiter = thread;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void setClosed(boolean bl) {
        this.closed = bl;
    }

    public T acceptClient() throws IOException, InterruptedException {
        if (this.isClosed()) {
            throw new IOException("closed");
        }
        this.setWaiter(Thread.currentThread());
        try {
            Client client = (Client)this.queue.take();
            return (T)client;
        }
        finally {
            this.setWaiter(null);
        }
    }

    public void addClient(T t) {
        this.queue.offer(t);
    }

    public synchronized void close() {
        this.setClosed(true);
        Thread thread = this.getWaiter();
        if (thread != null) {
            thread.interrupt();
        }
    }
}

