/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.server.InstrumentedServerSocketAppenderBase;
import ch.qos.logback.core.net.server.MockContext;
import ch.qos.logback.core.net.server.MockServerListener;
import ch.qos.logback.core.net.server.MockServerRunner;
import ch.qos.logback.core.net.server.RemoteReceiverClient;
import ch.qos.logback.core.net.server.ServerSocketUtil;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.io.IOException;
import java.net.ServerSocket;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerSocketAppenderBaseTest {
    private MockContext context = new MockContext();
    private MockServerRunner<RemoteReceiverClient> runner = new MockServerRunner();
    private MockServerListener<RemoteReceiverClient> listener = new MockServerListener();
    private ServerSocket serverSocket;
    private InstrumentedServerSocketAppenderBase appender;

    @Before
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        this.appender = new InstrumentedServerSocketAppenderBase(this.serverSocket, this.listener, this.runner);
        this.appender.setContext((Context)this.context);
    }

    @After
    public void tearDown() throws Exception {
        this.serverSocket.close();
    }

    @Test
    public void testStartStop() throws Exception {
        this.appender.start();
        Assert.assertTrue((boolean)this.runner.isContextInjected());
        Assert.assertTrue((boolean)this.runner.isRunning());
        Assert.assertSame(this.listener, (Object)this.appender.getLastListener());
        this.appender.stop();
        Assert.assertFalse((boolean)this.runner.isRunning());
    }

    @Test
    public void testStartWhenAlreadyStarted() throws Exception {
        this.appender.start();
        this.appender.start();
        Assert.assertEquals((long)1L, (long)this.runner.getStartCount());
    }

    @Test
    public void testStopThrowsException() throws Exception {
        this.appender.start();
        Assert.assertTrue((boolean)this.appender.isStarted());
        IOException iOException = new IOException("test exception");
        this.runner.setStopException(iOException);
        this.appender.stop();
        Status status = this.context.getLastStatus();
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)(status instanceof ErrorStatus));
        Assert.assertTrue((boolean)status.getMessage().contains(iOException.getMessage()));
        Assert.assertSame((Object)iOException, (Object)status.getThrowable());
    }

    @Test
    public void testStopWhenNotStarted() throws Exception {
        this.appender.stop();
        Assert.assertEquals((long)0L, (long)this.runner.getStartCount());
    }
}

