/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.Client;
import ch.qos.logback.core.net.server.ServerSocketListener;
import ch.qos.logback.core.net.server.ServerSocketUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerSocketListenerTest {
    private ServerSocket serverSocket;
    private ServerSocketListener listener;

    @Before
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        Assert.assertNotNull((Object)this.serverSocket);
        this.listener = new InstrumentedServerSocketListener(this.serverSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcceptClient() throws Exception {
        RunnableClient runnableClient = new RunnableClient(InetAddress.getLocalHost(), this.serverSocket.getLocalPort());
        Thread thread = new Thread((Runnable)((Object)runnableClient));
        thread.start();
        RunnableClient runnableClient2 = runnableClient;
        synchronized (runnableClient2) {
            int n = 200;
            while (n-- > 0 && !runnableClient.isConnected()) {
                runnableClient.wait(10L);
            }
        }
        Assert.assertTrue((boolean)runnableClient.isConnected());
        runnableClient.close();
        this.serverSocket.setSoTimeout(5000);
        runnableClient2 = this.listener.acceptClient();
        Assert.assertNotNull((Object)runnableClient2);
        runnableClient2.close();
    }

    private static class RunnableClient
    implements Client {
        private final InetAddress inetAddress;
        private final int port;
        private boolean connected;
        private boolean closed;

        public RunnableClient(InetAddress inetAddress, int n) {
            this.inetAddress = inetAddress;
            this.port = n;
        }

        public synchronized boolean isConnected() {
            return this.connected;
        }

        public synchronized void setConnected(boolean bl) {
            this.connected = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Socket socket = new Socket(this.inetAddress, this.port);
                RunnableClient runnableClient = this;
                synchronized (runnableClient) {
                    this.setConnected(true);
                    this.notifyAll();
                    while (!this.closed && !Thread.currentThread().isInterrupted()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    socket.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }

        public synchronized void close() {
            this.closed = true;
            this.notifyAll();
        }
    }

    private static class RemoteClient
    implements Client {
        private final Socket socket;

        public RemoteClient(Socket socket) {
            this.socket = socket;
        }

        public void run() {
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstrumentedServerSocketListener
    extends ServerSocketListener<RemoteClient> {
        public InstrumentedServerSocketListener(ServerSocket serverSocket) {
            super(serverSocket);
        }

        protected RemoteClient createClient(String string, Socket socket) throws IOException {
            return new RemoteClient(socket);
        }
    }
}

