/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.net.ssl.SecureRandomFactoryBean;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.junit.Assert;
import org.junit.Test;

public class SecureRandomFactoryBeanTest {
    private SecureRandomFactoryBean factoryBean = new SecureRandomFactoryBean();

    @Test
    public void testDefaults() throws Exception {
        Assert.assertNotNull((Object)this.factoryBean.createSecureRandom());
    }

    @Test
    public void testExplicitProvider() throws Exception {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        this.factoryBean.setProvider(secureRandom.getProvider().getName());
        Assert.assertNotNull((Object)this.factoryBean.createSecureRandom());
    }

    @Test
    public void testUnknownProvider() throws Exception {
        this.factoryBean.setProvider("A_FAKE_PROVIDER_NAME");
        try {
            this.factoryBean.createSecureRandom();
            Assert.fail((String)"expected NoSuchProviderException");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Assert.assertTrue((boolean)noSuchProviderException.getMessage().contains("A_FAKE_PROVIDER_NAME"));
        }
    }

    @Test
    public void testUnknownAlgorithm() throws Exception {
        this.factoryBean.setAlgorithm("A_FAKE_ALGORITHM_NAME");
        try {
            this.factoryBean.createSecureRandom();
            Assert.fail((String)"expected NoSuchAlgorithmException");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.assertTrue((boolean)noSuchAlgorithmException.getMessage().contains("A_FAKE_ALGORITHM_NAME"));
        }
    }
}

