/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.ExceptionalConverter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import junit.framework.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPatternLayoutBaseTest<E> {
    public abstract PatternLayoutBase<E> getPatternLayoutBase();

    public abstract E getEventObject();

    public abstract Context getContext();

    @Test
    public void testUnStarted() {
        PatternLayoutBase<E> patternLayoutBase = this.getPatternLayoutBase();
        ContextBase contextBase = new ContextBase();
        patternLayoutBase.setContext((Context)contextBase);
        String string = patternLayoutBase.doLayout(this.getEventObject());
        Assert.assertEquals((String)"", (String)string);
        StatusManager statusManager = contextBase.getStatusManager();
        StatusPrinter.print((StatusManager)statusManager);
    }

    @Test
    public void testConverterStart() {
        PatternLayoutBase<E> patternLayoutBase = this.getPatternLayoutBase();
        patternLayoutBase.setContext(this.getContext());
        patternLayoutBase.getInstanceConverterMap().put("EX", ExceptionalConverter.class.getName());
        patternLayoutBase.setPattern("%EX");
        patternLayoutBase.start();
        String string = patternLayoutBase.doLayout(this.getEventObject());
        Assert.assertFalse((boolean)string.contains("%PARSER_ERROR_EX"));
    }

    @Test
    public void testStarted() {
        PatternLayoutBase<E> patternLayoutBase = this.getPatternLayoutBase();
        ContextBase contextBase = new ContextBase();
        patternLayoutBase.setContext((Context)contextBase);
        String string = patternLayoutBase.doLayout(this.getEventObject());
        Assert.assertEquals((String)"", (String)string);
        StatusManager statusManager = contextBase.getStatusManager();
        StatusPrinter.print((StatusManager)statusManager);
    }

    @Test
    public void testNullPattern() {
        PatternLayoutBase<E> patternLayoutBase = this.getPatternLayoutBase();
        ContextBase contextBase = new ContextBase();
        patternLayoutBase.setContext((Context)contextBase);
        patternLayoutBase.setPattern(null);
        patternLayoutBase.start();
        String string = patternLayoutBase.doLayout(this.getEventObject());
        Assert.assertEquals((String)"", (String)string);
        StatusChecker statusChecker = new StatusChecker(contextBase.getStatusManager());
        statusChecker.assertContainsMatch("Empty or null pattern.");
    }

    @Test
    public void testEmptyPattern() {
        PatternLayoutBase<E> patternLayoutBase = this.getPatternLayoutBase();
        ContextBase contextBase = new ContextBase();
        patternLayoutBase.setContext((Context)contextBase);
        patternLayoutBase.setPattern("");
        patternLayoutBase.start();
        String string = patternLayoutBase.doLayout(this.getEventObject());
        Assert.assertEquals((String)"", (String)string);
        StatusChecker statusChecker = new StatusChecker(contextBase.getStatusManager());
        statusChecker.assertContainsMatch("Empty or null pattern.");
    }
}

