/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.Converter123;
import ch.qos.logback.core.pattern.ConverterHello;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerTest {
    Map<String, String> converterMap = new HashMap<String, String>();
    Context context = new ContextBase();

    @Before
    public void setUp() {
        this.converterMap.put("OTT", Converter123.class.getName());
        this.converterMap.put("hello", ConverterHello.class.getName());
        this.converterMap.putAll(Parser.DEFAULT_COMPOSITE_CONVERTER_MAP);
    }

    String write(Converter<Object> converter, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter converter2 = converter; converter2 != null; converter2 = converter2.getNext()) {
            converter2.write(stringBuilder, object);
        }
        return stringBuilder.toString();
    }

    @Test
    public void testLiteral() throws Exception {
        Parser parser = new Parser("hello");
        Node node = parser.parse();
        Converter converter = parser.compile(node, this.converterMap);
        String string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"hello", (String)string);
    }

    @Test
    public void testBasic() throws Exception {
        Parser parser = new Parser("abc %hello");
        parser.setContext(this.context);
        Node node = parser.parse();
        Converter converter = parser.compile(node, this.converterMap);
        String string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc Hello", (String)string);
        parser = new Parser("abc %hello %OTT");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc Hello 123", (String)string);
    }

    @Test
    public void testFormat() throws Exception {
        Parser parser = new Parser("abc %7hello");
        parser.setContext(this.context);
        Node node = parser.parse();
        Converter converter = parser.compile(node, this.converterMap);
        String string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc   Hello", (String)string);
        parser = new Parser("abc %-7hello");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc Hello  ", (String)string);
        parser = new Parser("abc %.3hello");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc llo", (String)string);
        parser = new Parser("abc %.-3hello");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc Hel", (String)string);
        parser = new Parser("abc %4.5OTT");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc  123", (String)string);
        parser = new Parser("abc %-4.5OTT");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc 123 ", (String)string);
        parser = new Parser("abc %3.4hello");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc ello", (String)string);
        parser = new Parser("abc %-3.-4hello");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"abc Hell", (String)string);
    }

    @Test
    public void testComposite() throws Exception {
        ContextBase contextBase = new ContextBase();
        Parser parser = new Parser("%(ABC %hello)");
        parser.setContext((Context)contextBase);
        Node node = parser.parse();
        Object object = parser.compile(node, this.converterMap);
        String string = this.write((Converter<Object>)object, new Object());
        StatusPrinter.print((Context)contextBase);
        Assert.assertEquals((String)"ABC Hello", (String)string);
        contextBase = new Parser("%(ABC %hello)");
        contextBase.setContext(this.context);
        parser = contextBase.parse();
        node = contextBase.compile((Node)parser, this.converterMap);
        object = this.write((Converter<Object>)node, new Object());
        Assert.assertEquals((String)"ABC Hello", (String)object);
    }

    @Test
    public void testCompositeFormatting() throws Exception {
        Parser parser = new Parser("xyz %4.10(ABC)");
        parser.setContext(this.context);
        Node node = parser.parse();
        Converter converter = parser.compile(node, this.converterMap);
        String string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"xyz  ABC", (String)string);
        parser = new Parser("xyz %-4.10(ABC)");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"xyz ABC ", (String)string);
        parser = new Parser("xyz %.2(ABC %hello)");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"xyz lo", (String)string);
        parser = new Parser("xyz %.-2(ABC)");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"xyz AB", (String)string);
        parser = new Parser("xyz %30.30(ABC %20hello)");
        parser.setContext(this.context);
        node = parser.parse();
        converter = parser.compile(node, this.converterMap);
        string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"xyz       ABC                Hello", (String)string);
    }

    @Test
    public void testUnknownWord() throws Exception {
        Parser parser = new Parser("%unknown");
        parser.setContext(this.context);
        Node node = parser.parse();
        parser.compile(node, this.converterMap);
        StatusChecker statusChecker = new StatusChecker(this.context.getStatusManager());
        statusChecker.assertContainsMatch("\\[unknown] is not a valid conversion word");
    }

    @Test
    public void testWithNopEscape() throws Exception {
        Parser parser = new Parser("xyz %hello\\_world");
        parser.setContext(this.context);
        Node node = parser.parse();
        Converter converter = parser.compile(node, this.converterMap);
        String string = this.write((Converter<Object>)converter, new Object());
        Assert.assertEquals((String)"xyz Helloworld", (String)string);
    }
}

