/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.FormatInfo;
import junit.framework.Assert;
import org.junit.Test;

public class FormatInfoTest {
    @Test
    public void testEndingInDot() {
        try {
            FormatInfo.valueOf((String)"45.");
            Assert.fail((String)"45. is not a valid format info string");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasic() {
        FormatInfo formatInfo = FormatInfo.valueOf((String)"45");
        FormatInfo formatInfo2 = new FormatInfo();
        formatInfo2.setMin(45);
        Assert.assertEquals((Object)formatInfo2, (Object)formatInfo);
        formatInfo = FormatInfo.valueOf((String)"4.5");
        formatInfo2 = new FormatInfo();
        formatInfo2.setMin(4);
        formatInfo2.setMax(5);
        Assert.assertEquals((Object)formatInfo2, (Object)formatInfo);
    }

    @Test
    public void testRightPad() {
        FormatInfo formatInfo = FormatInfo.valueOf((String)"-40");
        FormatInfo formatInfo2 = new FormatInfo();
        formatInfo2.setMin(40);
        formatInfo2.setLeftPad(false);
        Assert.assertEquals((Object)formatInfo2, (Object)formatInfo);
        formatInfo = FormatInfo.valueOf((String)"-12.5");
        formatInfo2 = new FormatInfo();
        formatInfo2.setMin(12);
        formatInfo2.setMax(5);
        formatInfo2.setLeftPad(false);
        Assert.assertEquals((Object)formatInfo2, (Object)formatInfo);
        formatInfo = FormatInfo.valueOf((String)"-14.-5");
        formatInfo2 = new FormatInfo();
        formatInfo2.setMin(14);
        formatInfo2.setMax(5);
        formatInfo2.setLeftPad(false);
        formatInfo2.setLeftTruncate(false);
        Assert.assertEquals((Object)formatInfo2, (Object)formatInfo);
    }

    @Test
    public void testMinOnly() {
        FormatInfo formatInfo = FormatInfo.valueOf((String)"49");
        FormatInfo formatInfo2 = new FormatInfo();
        formatInfo2.setMin(49);
        Assert.assertEquals((Object)formatInfo2, (Object)formatInfo);
        formatInfo = FormatInfo.valueOf((String)"-587");
        formatInfo2 = new FormatInfo();
        formatInfo2.setMin(587);
        formatInfo2.setLeftPad(false);
        Assert.assertEquals((Object)formatInfo2, (Object)formatInfo);
    }

    @Test
    public void testMaxOnly() {
        FormatInfo formatInfo = FormatInfo.valueOf((String)".49");
        FormatInfo formatInfo2 = new FormatInfo();
        formatInfo2.setMax(49);
        Assert.assertEquals((Object)formatInfo2, (Object)formatInfo);
        formatInfo = FormatInfo.valueOf((String)".-5");
        formatInfo2 = new FormatInfo();
        formatInfo2.setMax(5);
        formatInfo2.setLeftTruncate(false);
        Assert.assertEquals((Object)formatInfo2, (Object)formatInfo);
    }
}

