/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.status.StatusChecker;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;

public class ParserTest {
    String BARE = Token.BARE_COMPOSITE_KEYWORD_TOKEN.getValue().toString();
    Context context = new ContextBase();

    @Test
    public void testBasic() throws Exception {
        Parser parser = new Parser("hello");
        Node node = parser.parse();
        Assert.assertEquals((int)0, (int)node.getType());
        Assert.assertEquals((Object)"hello", (Object)node.getValue());
    }

    @Test
    public void testKeyword() throws Exception {
        Parser parser = new Parser("hello%xyz");
        Node node = parser.parse();
        Node node2 = new Node(0, (Object)"hello");
        node2.next = new SimpleKeywordNode((Object)"xyz");
        Assert.assertEquals((Object)node2, (Object)node);
        parser = new Parser("hello%xyz{x}");
        node = parser.parse();
        node2 = new Node(0, (Object)"hello");
        SimpleKeywordNode simpleKeywordNode = new SimpleKeywordNode((Object)"xyz");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("x");
        simpleKeywordNode.setOptions(arrayList);
        node2.next = simpleKeywordNode;
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void testComposite() throws Exception {
        Parser parser = new Parser("hello%(%child)");
        Node node = parser.parse();
        Node node2 = new Node(0, (Object)"hello");
        CompositeNode compositeNode = new CompositeNode(this.BARE);
        SimpleKeywordNode simpleKeywordNode = new SimpleKeywordNode((Object)"child");
        compositeNode.setChildNode((Node)simpleKeywordNode);
        node2.next = compositeNode;
        Assert.assertEquals((Object)node2, (Object)node);
        parser = new Parser("hello%(%child )");
        node = parser.parse();
        node2 = new Node(0, (Object)"hello");
        compositeNode = new CompositeNode(this.BARE);
        simpleKeywordNode = new SimpleKeywordNode((Object)"child");
        compositeNode.setChildNode((Node)simpleKeywordNode);
        node2.next = compositeNode;
        simpleKeywordNode.next = new Node(0, (Object)" ");
        Assert.assertEquals((Object)node2, (Object)node);
        parser = new Parser("hello%(%child %h)");
        node = parser.parse();
        node2 = new Node(0, (Object)"hello");
        compositeNode = new CompositeNode(this.BARE);
        simpleKeywordNode = new SimpleKeywordNode((Object)"child");
        compositeNode.setChildNode((Node)simpleKeywordNode);
        simpleKeywordNode.next = new Node(0, (Object)" ");
        simpleKeywordNode.next.next = new SimpleKeywordNode((Object)"h");
        node2.next = compositeNode;
        Assert.assertEquals((Object)node2, (Object)node);
        parser = new Parser("hello%(%child %h) %m");
        node = parser.parse();
        node2 = new Node(0, (Object)"hello");
        compositeNode = new CompositeNode(this.BARE);
        simpleKeywordNode = new SimpleKeywordNode((Object)"child");
        compositeNode.setChildNode((Node)simpleKeywordNode);
        simpleKeywordNode.next = new Node(0, (Object)" ");
        simpleKeywordNode.next.next = new SimpleKeywordNode((Object)"h");
        node2.next = compositeNode;
        compositeNode.next = new Node(0, (Object)" ");
        compositeNode.next.next = new SimpleKeywordNode((Object)"m");
        Assert.assertEquals((Object)node2, (Object)node);
        parser = new Parser("hello%( %child \\(%h\\) ) %m");
        node = parser.parse();
        node2 = new Node(0, (Object)"hello");
        compositeNode = new CompositeNode(this.BARE);
        simpleKeywordNode = new Node(0, (Object)" ");
        compositeNode.setChildNode((Node)simpleKeywordNode);
        SimpleKeywordNode simpleKeywordNode2 = simpleKeywordNode;
        simpleKeywordNode2.next = new SimpleKeywordNode((Object)"child");
        simpleKeywordNode2 = simpleKeywordNode2.next;
        simpleKeywordNode2.next = new Node(0, (Object)" (");
        simpleKeywordNode2 = simpleKeywordNode2.next;
        simpleKeywordNode2.next = new SimpleKeywordNode((Object)"h");
        simpleKeywordNode2 = simpleKeywordNode2.next;
        simpleKeywordNode2.next = new Node(0, (Object)") ");
        simpleKeywordNode2 = simpleKeywordNode2.next;
        node2.next = compositeNode;
        compositeNode.next = new Node(0, (Object)" ");
        compositeNode.next.next = new SimpleKeywordNode((Object)"m");
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void testNested() throws Exception {
        Parser parser = new Parser("%top %(%child%(%h))");
        Node node = parser.parse();
        SimpleKeywordNode simpleKeywordNode = new SimpleKeywordNode((Object)"top");
        Node node2 = simpleKeywordNode.next = new Node(0, (Object)" ");
        CompositeNode compositeNode = new CompositeNode(this.BARE);
        node2 = node2.next = compositeNode;
        SimpleKeywordNode simpleKeywordNode2 = new SimpleKeywordNode((Object)"child");
        compositeNode.setChildNode((Node)simpleKeywordNode2);
        compositeNode = new CompositeNode(this.BARE);
        simpleKeywordNode2.next = compositeNode;
        compositeNode.setChildNode((Node)new SimpleKeywordNode((Object)"h"));
        Assert.assertEquals((Object)simpleKeywordNode, (Object)node);
    }

    @Test
    public void testFormattingInfo() throws Exception {
        Parser parser = new Parser("%45x");
        Node node = parser.parse();
        SimpleKeywordNode simpleKeywordNode = new SimpleKeywordNode((Object)"x");
        simpleKeywordNode.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        Assert.assertEquals((Object)simpleKeywordNode, (Object)node);
        parser = new Parser("%4.5x");
        node = parser.parse();
        simpleKeywordNode = new SimpleKeywordNode((Object)"x");
        simpleKeywordNode.setFormatInfo(new FormatInfo(4, 5));
        Assert.assertEquals((Object)simpleKeywordNode, (Object)node);
        parser = new Parser("%-4.5x");
        node = parser.parse();
        simpleKeywordNode = new SimpleKeywordNode((Object)"x");
        simpleKeywordNode.setFormatInfo(new FormatInfo(4, 5, false, true));
        Assert.assertEquals((Object)simpleKeywordNode, (Object)node);
        parser = new Parser("%-4.-5x");
        node = parser.parse();
        simpleKeywordNode = new SimpleKeywordNode((Object)"x");
        simpleKeywordNode.setFormatInfo(new FormatInfo(4, 5, false, false));
        Assert.assertEquals((Object)simpleKeywordNode, (Object)node);
        parser = new Parser("%-4.5x %12y");
        node = parser.parse();
        simpleKeywordNode = new SimpleKeywordNode((Object)"x");
        simpleKeywordNode.setFormatInfo(new FormatInfo(4, 5, false, true));
        Node node2 = simpleKeywordNode.next = new Node(0, (Object)" ");
        node2 = node2.next = new SimpleKeywordNode((Object)"y");
        ((FormattingNode)node2).setFormatInfo(new FormatInfo(12, Integer.MAX_VALUE));
        Assert.assertEquals((Object)simpleKeywordNode, (Object)node);
    }

    @Test
    public void testOptions0() throws Exception {
        Parser parser = new Parser("%45x{'test '}");
        Node node = parser.parse();
        SimpleKeywordNode simpleKeywordNode = new SimpleKeywordNode((Object)"x");
        simpleKeywordNode.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("test ");
        simpleKeywordNode.setOptions(arrayList);
        Assert.assertEquals((Object)simpleKeywordNode, (Object)node);
    }

    @Test
    public void testOptions1() throws Exception {
        Parser parser = new Parser("%45x{a, b}");
        Node node = parser.parse();
        SimpleKeywordNode simpleKeywordNode = new SimpleKeywordNode((Object)"x");
        simpleKeywordNode.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("a");
        arrayList.add("b");
        simpleKeywordNode.setOptions(arrayList);
        Assert.assertEquals((Object)simpleKeywordNode, (Object)node);
    }

    @Test
    public void keywordGluedToLitteral() throws Exception {
        Parser parser = new Parser("%x{}a");
        Node node = parser.parse();
        SimpleKeywordNode simpleKeywordNode = new SimpleKeywordNode((Object)"x");
        simpleKeywordNode.setOptions(new ArrayList());
        simpleKeywordNode.next = new Node(0, (Object)"a");
        Assert.assertEquals((Object)simpleKeywordNode, (Object)node);
    }

    @Test
    public void testCompositeFormatting() throws Exception {
        Parser parser = new Parser("hello%5(XYZ)");
        Node node = parser.parse();
        Node node2 = new Node(0, (Object)"hello");
        CompositeNode compositeNode = new CompositeNode(this.BARE);
        compositeNode.setFormatInfo(new FormatInfo(5, Integer.MAX_VALUE));
        Node node3 = new Node(0, (Object)"XYZ");
        compositeNode.setChildNode(node3);
        node2.next = compositeNode;
        Assert.assertEquals((Object)node2, (Object)node);
    }

    @Test
    public void empty() {
        try {
            Parser parser = new Parser("");
            parser.parse();
            Assert.fail((String)"");
        }
        catch (ScanException scanException) {
            // empty catch block
        }
    }

    @Test
    public void lbcore193() throws Exception {
        Object object;
        try {
            object = new Parser("hello%(abc");
            object.setContext(this.context);
            Node node = object.parse();
            Assert.fail((String)"where the is exception?");
        }
        catch (ScanException scanException) {
            Assert.assertEquals((String)"Expecting RIGHT_PARENTHESIS token but got null", (String)scanException.getMessage());
        }
        object = new StatusChecker(this.context);
        ((StatusChecker)((Object)object)).assertContainsMatch("Expecting RIGHT_PARENTHESIS");
        ((StatusChecker)((Object)object)).assertContainsMatch("See also http://logback.qos.ch/codes.html#missingRightParenthesis");
    }
}

