/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.pattern.parser.AbstractPatternLayoutBaseTest;
import ch.qos.logback.core.pattern.parser.SamplePatternLayout;
import junit.framework.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplePatternLayoutTest
extends AbstractPatternLayoutBaseTest<Object> {
    Context context = new ContextBase();

    @Override
    public PatternLayoutBase<Object> getPatternLayoutBase() {
        return new SamplePatternLayout<Object>();
    }

    @Override
    public Object getEventObject() {
        return new Object();
    }

    @Test
    public void testOK() {
        PatternLayoutBase<Object> patternLayoutBase = this.getPatternLayoutBase();
        ContextBase contextBase = new ContextBase();
        patternLayoutBase.setContext((Context)contextBase);
        patternLayoutBase.setPattern("x%OTT");
        patternLayoutBase.start();
        String string = patternLayoutBase.doLayout(new Object());
        Assert.assertEquals((String)"x123", (String)string);
    }

    @Test
    public void testEscapeClosingParentheses() {
        PatternLayoutBase<Object> patternLayoutBase = this.getPatternLayoutBase();
        ContextBase contextBase = new ContextBase();
        patternLayoutBase.setContext((Context)contextBase);
        patternLayoutBase.setPattern("x(%OTT\\)y");
        patternLayoutBase.start();
        String string = patternLayoutBase.doLayout(new Object());
        Assert.assertEquals((String)"x(123)y", (String)string);
    }

    @Test
    public void testEscapeBothParentheses() {
        PatternLayoutBase<Object> patternLayoutBase = this.getPatternLayoutBase();
        ContextBase contextBase = new ContextBase();
        patternLayoutBase.setContext((Context)contextBase);
        patternLayoutBase.setPattern("x\\(%OTT\\)y");
        patternLayoutBase.start();
        String string = patternLayoutBase.doLayout(new Object());
        Assert.assertEquals((String)"x(123)y", (String)string);
    }

    @Test
    public void testPercentAsLiteral() {
        PatternLayoutBase<Object> patternLayoutBase = this.getPatternLayoutBase();
        ContextBase contextBase = new ContextBase();
        patternLayoutBase.setContext((Context)contextBase);
        patternLayoutBase.setPattern("hello \\% world");
        patternLayoutBase.start();
        String string = patternLayoutBase.doLayout(new Object());
        Assert.assertEquals((String)"hello % world", (String)string);
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

