/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.pattern.util.AlmostAsIsEscapeUtil;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class TokenStreamTest {
    @Test
    public void testEmpty() throws ScanException {
        try {
            new TokenStream("").tokenize();
            Assert.fail((String)"empty string not allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSingleLiteral() throws ScanException {
        List list = new TokenStream("hello").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(new Token(1000, (Object)"hello"));
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testLiteralWithPercent() throws ScanException {
        List list = new TokenStream("hello\\%world").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(new Token(1000, (Object)"hello%world"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("hello\\%").tokenize();
        arrayList = new ArrayList();
        arrayList.add(new Token(1000, (Object)"hello%"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("\\%").tokenize();
        arrayList = new ArrayList();
        arrayList.add(new Token(1000, (Object)"%"));
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testBasic() throws ScanException {
        List list = new TokenStream("%c").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"c"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("%a%b").tokenize();
        arrayList = new ArrayList();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"a"));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"b"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("xyz%-34c").tokenize();
        arrayList = new ArrayList();
        arrayList.add(new Token(1000, (Object)"xyz"));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1002, (Object)"-34"));
        arrayList.add(new Token(1004, (Object)"c"));
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testComplexNR() throws ScanException {
        List list = new TokenStream("%d{1234} [%34.-67toto] %n").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"d"));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("1234");
        arrayList.add(new Token(1006, arrayList2));
        arrayList.add(new Token(1000, (Object)" ["));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1002, (Object)"34.-67"));
        arrayList.add(new Token(1004, (Object)"toto"));
        arrayList.add(new Token(1000, (Object)"] "));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"n"));
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testEmptyP() throws ScanException {
        List list = new TokenStream("()").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(new Token(1000, (Object)"("));
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testEmptyP2() throws ScanException {
        List list = new TokenStream("%()").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testEscape() throws ScanException {
        List list = new TokenStream("\\%").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(new Token(1000, (Object)"%"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("\\%\\(\\t\\)\\r\\n").tokenize();
        arrayList = new ArrayList();
        arrayList.add(new Token(1000, (Object)"%(\t)\r\n"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("\\\\%x").tokenize();
        arrayList = new ArrayList();
        arrayList.add(new Token(1000, (Object)"\\"));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"x"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("%x\\)").tokenize();
        arrayList = new ArrayList();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"x"));
        arrayList.add(new Token(1000, (Object)")"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("%x\\_a").tokenize();
        arrayList = new ArrayList();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"x"));
        arrayList.add(new Token(1000, (Object)"a"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("%x\\_%b").tokenize();
        arrayList = new ArrayList();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"x"));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"b"));
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testOptions() throws ScanException {
        List list = new TokenStream("%x{t}").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"x"));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("t");
        arrayList.add(new Token(1006, arrayList2));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("%x{t,y}").tokenize();
        arrayList = new ArrayList();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"x"));
        arrayList2 = new ArrayList();
        arrayList2.add("t");
        arrayList2.add("y");
        arrayList.add(new Token(1006, arrayList2));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("%x{\"hello world.\", \"12y  \"}").tokenize();
        arrayList = new ArrayList();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"x"));
        arrayList2 = new ArrayList();
        arrayList2.add("hello world.");
        arrayList2.add("12y  ");
        arrayList.add(new Token(1006, arrayList2));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("%x{'opt}'}").tokenize();
        arrayList = new ArrayList();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"x"));
        arrayList2 = new ArrayList();
        arrayList2.add("opt}");
        arrayList.add(new Token(1006, arrayList2));
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testSimpleP() throws ScanException {
        List list = new TokenStream("%(hello %class{.4?})").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        arrayList.add(new Token(1000, (Object)"hello "));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"class"));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(".4?");
        arrayList.add(new Token(1006, arrayList2));
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testSimpleP2() throws ScanException {
        List list = new TokenStream("X %a %-12.550(hello %class{.4?})").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(new Token(1000, (Object)"X "));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"a"));
        arrayList.add(new Token(1000, (Object)" "));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1002, (Object)"-12.550"));
        arrayList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        arrayList.add(new Token(1000, (Object)"hello "));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"class"));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(".4?");
        arrayList.add(new Token(1006, arrayList2));
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testMultipleRecursion() throws ScanException {
        List list = new TokenStream("%-1(%d %45(%class %file))").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1002, (Object)"-1"));
        arrayList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"d"));
        arrayList.add(new Token(1000, (Object)" "));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1002, (Object)"45"));
        arrayList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"class"));
        arrayList.add(new Token(1000, (Object)" "));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"file"));
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testNested() throws ScanException {
        List list = new TokenStream("%(%a%(%b))").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"a"));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"b"));
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testEscapedParanteheses() throws ScanException {
        List list = new TokenStream("\\(%h\\)").tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(new Token(1000, (Object)"("));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"h"));
        arrayList.add(new Token(1000, (Object)")"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("(%h\\)").tokenize();
        arrayList = new ArrayList();
        arrayList.add(new Token(1000, (Object)"("));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"h"));
        arrayList.add(new Token(1000, (Object)")"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("%a(x\\)").tokenize();
        arrayList = new ArrayList();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1005, (Object)"a"));
        arrayList.add(new Token(1000, (Object)"x)"));
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("%a\\(x)").tokenize();
        arrayList = new ArrayList();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"a"));
        arrayList.add(new Token(1000, (Object)"(x"));
        arrayList.add(new Token(41));
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void testWindowsLikeBackSlashes() throws ScanException {
        List list = new TokenStream("c:\\hello\\world.%i", (IEscapeUtil)new AlmostAsIsEscapeUtil()).tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(new Token(1000, (Object)"c:\\hello\\world."));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"i"));
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void compositedKeyword() throws ScanException {
        List list = new TokenStream("%d(A)", (IEscapeUtil)new AlmostAsIsEscapeUtil()).tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1005, (Object)"d"));
        arrayList.add(new Token(1000, (Object)"A"));
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(arrayList, (Object)list);
        list = new TokenStream("a %subst(%b C)", (IEscapeUtil)new AlmostAsIsEscapeUtil()).tokenize();
        arrayList = new ArrayList();
        arrayList.add(new Token(1000, (Object)"a "));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1005, (Object)"subst"));
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1004, (Object)"b"));
        arrayList.add(new Token(1000, (Object)" C"));
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        Assert.assertEquals(arrayList, (Object)list);
    }

    @Test
    public void compositedKeywordFollowedByOptions() throws ScanException {
        List list = new TokenStream("%d(A){o}", (IEscapeUtil)new AlmostAsIsEscapeUtil()).tokenize();
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(Token.PERCENT_TOKEN);
        arrayList.add(new Token(1005, (Object)"d"));
        arrayList.add(new Token(1000, (Object)"A"));
        arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("o");
        arrayList.add(new Token(1006, arrayList2));
        Assert.assertEquals(arrayList, (Object)list);
    }
}

