/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.recovery.RecoveryCoordinator;
import junit.framework.Assert;
import org.junit.Test;

public class RecoveryCoordinatorTest {
    @Test
    public void recoveryNotNeededAfterInit() {
        RecoveryCoordinator recoveryCoordinator = new RecoveryCoordinator();
        Assert.assertTrue((boolean)recoveryCoordinator.isTooSoon());
    }

    @Test
    public void recoveryNotNeededIfAsleepForLessThanBackOffTime() throws InterruptedException {
        RecoveryCoordinator recoveryCoordinator = new RecoveryCoordinator();
        Thread.sleep(10L);
        Assert.assertTrue((boolean)recoveryCoordinator.isTooSoon());
    }

    @Test
    public void recoveryNeededIfAsleepForMoreThanBackOffTime() throws InterruptedException {
        RecoveryCoordinator recoveryCoordinator = new RecoveryCoordinator();
        Thread.sleep(40L);
        Assert.assertFalse((boolean)recoveryCoordinator.isTooSoon());
    }

    @Test
    public void recoveryNotNeededIfCurrentTimeSetToBackOffTime() throws InterruptedException {
        RecoveryCoordinator recoveryCoordinator = new RecoveryCoordinator();
        long l = System.currentTimeMillis();
        recoveryCoordinator.setCurrentTime(l + 20L);
        Assert.assertTrue((boolean)recoveryCoordinator.isTooSoon());
    }

    @Test
    public void recoveryNeededIfCurrentTimeSetToExceedBackOffTime() {
        RecoveryCoordinator recoveryCoordinator = new RecoveryCoordinator();
        long l = System.currentTimeMillis();
        recoveryCoordinator.setCurrentTime(l + 20L + 1L);
        Assert.assertFalse((boolean)recoveryCoordinator.isTooSoon());
    }

    @Test
    public void recoveryConditionDetectedEvenAfterReallyLongTimesBetweenRecovery() {
        RecoveryCoordinator recoveryCoordinator = new RecoveryCoordinator();
        long l = System.currentTimeMillis();
        long l2 = 20L;
        for (int i = 0; i < 16; ++i) {
            recoveryCoordinator.setCurrentTime(l + l2);
            if (i % 2 == 0) {
                Assert.assertTrue((String)("recovery should've been needed at " + l2), (boolean)recoveryCoordinator.isTooSoon());
            } else {
                Assert.assertFalse((String)("recovery should NOT have been needed at " + l2), (boolean)recoveryCoordinator.isTooSoon());
            }
            l2 *= 2L;
        }
    }
}

