/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class ResilientOutputStreamTest {
    int diff = RandomUtil.getPositiveInt();
    Context context = new ContextBase();

    @BeforeClass
    public static void setUp() {
        File file = new File("target/test-output/");
        file.mkdirs();
    }

    @Test
    public void verifyRecuperationAfterFailure() throws Exception {
        File file = new File("target/test-output/resilient" + this.diff + ".log");
        ResilientFileOutputStream resilientFileOutputStream = new ResilientFileOutputStream(file, true);
        resilientFileOutputStream.setContext(this.context);
        ResilientFileOutputStream resilientFileOutputStream2 = (ResilientFileOutputStream)Mockito.spy((Object)resilientFileOutputStream);
        resilientFileOutputStream2.write("a".getBytes());
        resilientFileOutputStream2.flush();
        resilientFileOutputStream2.getChannel().close();
        resilientFileOutputStream2.write("b".getBytes());
        resilientFileOutputStream2.flush();
        Thread.sleep(30L);
        resilientFileOutputStream2.write("c".getBytes());
        resilientFileOutputStream2.flush();
        ((ResilientFileOutputStream)Mockito.verify((Object)resilientFileOutputStream2)).openNewOutputStream();
    }
}

