/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.contention.MultiThreadedHarness;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.testUtil.EnvUtilForTests;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiThreadedRollingTest {
    static final int SUCCESSFUL_EXIT_CODE = 8;
    static final int FAILURE_EXIT_CODE = 1;
    static final int NUM_THREADS = 10;
    static final int TOTAL_DURATION = 600;
    RunnableWithCounterAndDone[] runnableArray;
    Encoder<Object> encoder;
    Context context = new ContextBase();
    static String VERIFY_SH = "verify.sh";
    int diff = RandomUtil.getPositiveInt();
    String outputDirStr = "target/test-output/multi-" + this.diff + "/";
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    String pathToBash = EnvUtilForTests.getPathToBash();
    OutputStream scriptOS;

    @Before
    public void setUp() throws Exception {
        this.encoder = new EchoEncoder();
        File file = new File(this.outputDirStr);
        file.mkdirs();
        System.out.println("Output dir [" + this.outputDirStr + "]");
        this.scriptOS = this.openScript();
        this.rfa.setName("rolling");
        this.rfa.setEncoder(this.encoder);
        this.rfa.setContext(this.context);
        this.rfa.setFile(this.outputDirStr + "output.log");
    }

    void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        this.rfa.stop();
    }

    public void setUpTimeBasedTriggeringPolicy(RollingFileAppender<Object> rollingFileAppender) {
        String string = "yyyy-MM-dd'T'HH_mm_ss_SSS";
        TimeBasedRollingPolicy timeBasedRollingPolicy = new TimeBasedRollingPolicy();
        timeBasedRollingPolicy.setFileNamePattern(this.outputDirStr + "test-%d{" + string + "}");
        timeBasedRollingPolicy.setContext(this.context);
        timeBasedRollingPolicy.setParent(rollingFileAppender);
        timeBasedRollingPolicy.start();
        rollingFileAppender.setRollingPolicy((RollingPolicy)timeBasedRollingPolicy);
        rollingFileAppender.start();
    }

    public void setUpSizeBasedTriggeringPolicy(RollingFileAppender<Object> rollingFileAppender) {
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
        sizeBasedTriggeringPolicy.setContext(this.context);
        sizeBasedTriggeringPolicy.setMaxFileSize("100KB");
        sizeBasedTriggeringPolicy.start();
        rollingFileAppender.setTriggeringPolicy((TriggeringPolicy)sizeBasedTriggeringPolicy);
        FixedWindowRollingPolicy fixedWindowRollingPolicy = new FixedWindowRollingPolicy();
        fixedWindowRollingPolicy.setContext(this.context);
        fixedWindowRollingPolicy.setFileNamePattern(this.outputDirStr + "test-%i.log");
        fixedWindowRollingPolicy.setMaxIndex(20);
        fixedWindowRollingPolicy.setMinIndex(0);
        fixedWindowRollingPolicy.setParent(rollingFileAppender);
        fixedWindowRollingPolicy.start();
        rollingFileAppender.setRollingPolicy((RollingPolicy)fixedWindowRollingPolicy);
        rollingFileAppender.start();
    }

    RunnableWithCounterAndDone[] buildRunnableArray(boolean bl) {
        RunnableWithCounterAndDone[] runnableWithCounterAndDoneArray = new RunnableWithCounterAndDone[10];
        for (int i = 0; i < 10; ++i) {
            runnableWithCounterAndDoneArray[i] = new RFARunnable(i, this.rfa, bl);
        }
        return runnableWithCounterAndDoneArray;
    }

    OutputStream openScript() throws IOException {
        return new FileOutputStream(this.outputDirStr + VERIFY_SH);
    }

    @Test
    public void multiThreadedTimedBased() throws InterruptedException, IOException {
        this.setUpTimeBasedTriggeringPolicy(this.rfa);
        this.executeHarness(600, false);
        this.printScriptForTimeBased();
        this.verify();
    }

    int testFileCount() {
        File file = new File(this.outputDirStr);
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.matches("test-\\d{1,2}.log");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        return fileArray.length;
    }

    void verify() throws IOException, InterruptedException {
        this.close(this.scriptOS);
        if (this.pathToBash == null) {
            return;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(this.pathToBash, VERIFY_SH);
        processBuilder.directory(new File(this.outputDirStr));
        Process process = processBuilder.start();
        process.waitFor();
        int n = process.exitValue();
        Assert.assertEquals((int)8, (int)n);
        System.out.println("External script based verification returned with exit code " + n);
    }

    @Test
    public void multiThreadedSizeBased() throws InterruptedException, IOException {
        this.setUpSizeBasedTriggeringPolicy(this.rfa);
        this.executeHarness(600, true);
        int n = this.testFileCount();
        this.printScriptForSizeBased(n);
        this.verify();
    }

    private void printScriptHeader(String string) throws IOException {
        this.out("# ====================================================");
        this.out("# A script to check the exactness of the output ");
        this.out("# produced by " + string + " test");
        this.out("# ====================================================");
        this.out("# ");
    }

    private void printCommonScriptCore() throws IOException {
        this.out("");
        this.out("for t in $(seq 0 1 9)");
        this.out("do");
        this.out("  echo \"Testing results of thread $t\"");
        this.out("  grep \"$t \" aggregated | cut -d ' ' -f 2 > ${t}-sample");
        this.out("  for j in $(seq 1 1 ${end[$t]}); do echo $j; done > ${t}-witness");
        this.out("  diff -q -w ${t}-sample ${t}-witness;");
        this.out("  res=$?");
        this.out("  if [ $res != \"0\" ]; then");
        this.out("    echo \"FAILED for $t\"");
        this.out("    exit 1");
        this.out("  fi");
        this.out("done");
        this.out("");
        this.out("exit 8");
    }

    private void printScriptForTimeBased() throws IOException {
        this.printScriptHeader("TimeBased");
        for (int i = 0; i < 10; ++i) {
            this.out("end[" + i + "]=" + this.runnableArray[i].getCounter());
        }
        this.out("");
        this.out("rm aggregated");
        this.out("cat test* output.log >> aggregated");
        this.printCommonScriptCore();
    }

    private void printScriptForSizeBased(int n) throws IOException {
        this.printScriptHeader("SizeBased");
        for (int i = 0; i < 10; ++i) {
            this.out("end[" + i + "]=" + this.runnableArray[i].getCounter());
        }
        this.out("");
        this.out("rm aggregated");
        this.out("for i in $(seq " + (n - 1) + " -1 0); do cat test-$i.log >> aggregated; done");
        this.out("cat output.log >> aggregated");
        this.out("");
        this.printCommonScriptCore();
    }

    private void out(String string) throws IOException {
        this.scriptOS.write(string.getBytes());
        this.scriptOS.write("\n".getBytes());
    }

    private void executeHarness(int n, boolean bl) throws InterruptedException {
        MultiThreadedHarness multiThreadedHarness = new MultiThreadedHarness(n);
        this.runnableArray = this.buildRunnableArray(bl);
        multiThreadedHarness.execute(this.runnableArray);
        StatusChecker statusChecker = new StatusChecker(this.context.getStatusManager());
        if (!statusChecker.isErrorFree(0L)) {
            StatusPrinter.print((Context)this.context);
            Assert.fail((String)"errors reported");
        }
    }

    long diff(long l) {
        return System.currentTimeMillis() - l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RFARunnable
    extends RunnableWithCounterAndDone {
        RollingFileAppender<Object> rfa;
        int id;
        boolean withInducedDelay;

        RFARunnable(int n, RollingFileAppender<Object> rollingFileAppender, boolean bl) {
            this.id = n;
            this.rfa = rollingFileAppender;
            this.withInducedDelay = bl;
        }

        @Override
        public void run() {
            while (!this.isDone()) {
                ++this.counter;
                this.rfa.doAppend((Object)(this.id + " " + this.counter));
                if (this.counter % 64L != 0L || !this.withInducedDelay) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

