/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.testUtil.FileToBufferUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaffoldingForRollingTests {
    public static final String DATE_PATTERN_WITH_SECONDS = "yyyy-MM-dd_HH_mm_ss";
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDir = "target/test-output/" + this.diff + "/";
    EchoEncoder<Object> encoder = new EchoEncoder();
    Context context = new ContextBase();
    protected List<String> expectedFilenameList = new ArrayList<String>();
    protected long nextRolloverThreshold;
    protected long currentTime;
    protected List<Future<?>> futureList = new ArrayList();
    Calendar calendar = Calendar.getInstance();

    public void setUp() {
        this.context.setName("test");
        this.calendar.set(14, 333);
        this.currentTime = this.calendar.getTimeInMillis();
        this.recomputeRolloverThreshold(this.currentTime);
    }

    public static void existenceCheck(String string) {
        Assert.assertTrue((String)("File " + string + " does not exist"), (boolean)new File(string).exists());
    }

    public static File[] getFilesInDirectory(String string) {
        File file = new File(string);
        return file.listFiles();
    }

    public static void fileContentCheck(File[] fileArray, int n, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : fileArray) {
            FileToBufferUtil.readIntoList(file, arrayList);
        }
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(string + i);
        }
        Assert.assertEquals((Object)arrayList2, arrayList);
    }

    public static void sortedContentCheck(String string, int n, String string2) throws IOException {
        File[] fileArray = ScaffoldingForRollingTests.getFilesInDirectory(string);
        FileFilterUtil.sortFileArrayByName((File[])fileArray);
        ScaffoldingForRollingTests.fileContentCheck(fileArray, n, string2);
    }

    public static void reverseSortedContentCheck(String string, int n, String string2) throws IOException {
        File[] fileArray = ScaffoldingForRollingTests.getFilesInDirectory(string);
        FileFilterUtil.reverseSortFileArrayByName((File[])fileArray);
        ScaffoldingForRollingTests.fileContentCheck(fileArray, n, string2);
    }

    public static void existenceCheck(List<String> list) {
        for (String string : list) {
            Assert.assertTrue((String)("File " + string + " does not exist"), (boolean)new File(string).exists());
        }
    }

    public static int existenceCount(List<String> list) {
        int n = 0;
        for (String string : list) {
            if (!new File(string).exists()) continue;
            ++n;
        }
        return n;
    }

    String testId2FileName(String string) {
        return this.randomOutputDir + string + ".log";
    }

    protected void recomputeRolloverThreshold(long l) {
        long l2 = l % 1000L;
        this.nextRolloverThreshold = l - l2 + 1000L;
    }

    protected boolean passThresholdTime(long l) {
        return this.currentTime >= l;
    }

    protected void incCurrentTime(long l) {
        this.currentTime += l;
    }

    protected Date getDateOfCurrentPeriodsStart() {
        long l = this.currentTime % 1000L;
        return new Date(this.currentTime - l);
    }

    protected Date getDateOfPreviousPeriodsStart() {
        long l = this.currentTime % 1000L;
        return new Date(this.currentTime - l - 1000L);
    }

    protected long getMillisOfCurrentPeriodsStart() {
        long l = this.currentTime % 1000L;
        return this.currentTime - l;
    }

    protected void addExpectedFileName_ByDate(String string, long l) {
        FileNamePattern fileNamePattern = new FileNamePattern(string, this.context);
        String string2 = fileNamePattern.convert((Object)new Date(l));
        this.expectedFilenameList.add(string2);
    }

    void addExpectedFileNamedIfItsTime_ByDate(String string) {
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.addExpectedFileName_ByDate(string, this.getMillisOfCurrentPeriodsStart());
            this.recomputeRolloverThreshold(this.currentTime);
        }
    }

    protected void addExpectedFileName_ByDate(String string, String string2, Date date, boolean bl) {
        String string3 = string + string2 + "-" + SDF.format(date);
        if (bl) {
            string3 = string3 + ".gz";
        }
        this.expectedFilenameList.add(string3);
    }

    protected void addExpectedFileName_ByFileIndexCounter(String string, String string2, long l, int n, String string3) {
        String string4 = string + string2 + "-" + SDF.format(l) + "-" + n + ".txt" + string3;
        this.expectedFilenameList.add(string4);
    }

    protected List<String> filterElementsInListBySuffix(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.expectedFilenameList) {
            if (!string2.endsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected void addExpectedFileNamedIfItsTime_ByDate(String string, String string2, boolean bl) {
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.addExpectedFileName_ByDate(string, string2, this.getDateOfCurrentPeriodsStart(), bl);
            this.recomputeRolloverThreshold(this.currentTime);
        }
    }

    void massageExpectedFilesToCorresponToCurrentTarget(String string, boolean bl) {
        int n = this.expectedFilenameList.size() - 1;
        String string2 = this.expectedFilenameList.remove(n);
        if (bl) {
            this.expectedFilenameList.add(string);
        } else if (string2.endsWith(".gz")) {
            int n2 = string2.length();
            String string3 = string2.substring(0, n2 - 3);
            this.expectedFilenameList.add(string3);
        }
    }

    String addGZIfNotLast(int n) {
        int n2 = this.expectedFilenameList.size() - 1;
        if (n != n2) {
            return ".gz";
        }
        return "";
    }

    void zipEntryNameCheck(List<String> list, String string) throws IOException {
        for (String string2 : list) {
            this.checkZipEntryName(string2, string);
        }
    }

    void checkZipEntryMatchesZipFilename(List<String> list) throws IOException {
        for (String string : list) {
            String string2 = this.stripStemFromZipFilename(string);
            this.checkZipEntryName(string, string2);
        }
    }

    String stripStemFromZipFilename(String string) {
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.length();
        return string2.substring(0, n - ".zip".length());
    }

    void checkZipEntryName(String string, String string2) throws IOException {
        System.out.println("Checking [" + string + "]");
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        assert (enumeration.hasMoreElements());
        ZipEntry zipEntry = enumeration.nextElement();
        assert (!enumeration.hasMoreElements());
        System.out.println("Testing zip entry [" + zipEntry.getName() + "]");
        Assert.assertTrue((boolean)zipEntry.getName().matches(string2));
    }

    protected void add(Future future) {
        if (future == null) {
            return;
        }
        if (!this.futureList.contains(future)) {
            this.futureList.add(future);
        }
    }

    protected void waitForJobsToComplete() {
        for (Future<?> future : this.futureList) {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                new RuntimeException("unexpected exception while testing", exception);
            }
        }
    }
}

