/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.ScaffoldingForRollingTests;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeAndTimeBasedFNATP_Test
extends ScaffoldingForRollingTests {
    private SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = null;
    private RollingFileAppender<Object> rfa1 = new RollingFileAppender();
    private TimeBasedRollingPolicy<Object> tbrp1 = new TimeBasedRollingPolicy();
    private RollingFileAppender<Object> rfa2 = new RollingFileAppender();
    private TimeBasedRollingPolicy<Object> tbrp2 = new TimeBasedRollingPolicy();
    private EchoEncoder<Object> encoder = new EchoEncoder();
    int fileSize = 0;
    int fileIndexCounter = 0;
    int sizeThreshold = 0;
    static final boolean FIRST_PHASE_ONLY = false;
    static final boolean WITH_SECOND_PHASE = true;
    static String DEFAULT_COMPRESSION_SUFFIX = "";

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    private void initRollingFileAppender(RollingFileAppender<Object> rollingFileAppender, String string) {
        rollingFileAppender.setContext(this.context);
        rollingFileAppender.setEncoder(this.encoder);
        if (string != null) {
            rollingFileAppender.setFile(string);
        }
    }

    private void initPolicies(RollingFileAppender<Object> rollingFileAppender, TimeBasedRollingPolicy<Object> timeBasedRollingPolicy, String string, int n, long l, long l2) {
        this.sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        timeBasedRollingPolicy.setContext(this.context);
        this.sizeAndTimeBasedFNATP.setMaxFileSize("" + n);
        timeBasedRollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)this.sizeAndTimeBasedFNATP);
        timeBasedRollingPolicy.setFileNamePattern(string);
        timeBasedRollingPolicy.setParent(rollingFileAppender);
        timeBasedRollingPolicy.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(l);
        rollingFileAppender.setRollingPolicy(timeBasedRollingPolicy);
        timeBasedRollingPolicy.start();
        rollingFileAppender.start();
    }

    private void addExpectedFileNamedIfItsTime(String string, String string2, String string3, String string4) {
        this.fileSize += string3.getBytes().length;
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.fileIndexCounter = 0;
            this.fileSize = 0;
            this.addExpectedFileName_ByFileIndexCounter(string, string2, this.getMillisOfCurrentPeriodsStart(), this.fileIndexCounter, string4);
            this.recomputeRolloverThreshold(this.currentTime);
            return;
        }
        if (this.fileIndexCounter < 1 && this.fileSize > this.sizeThreshold) {
            this.addExpectedFileName_ByFileIndexCounter(string, string2, this.getMillisOfCurrentPeriodsStart(), this.fileIndexCounter, string4);
            ++this.fileIndexCounter;
            this.fileSize = 0;
        }
    }

    void generic(String string, String string2, boolean bl, String string3) throws IOException, InterruptedException, ExecutionException {
        String string4 = string2 != null ? this.randomOutputDir + string2 : null;
        this.initRollingFileAppender(this.rfa1, string4);
        this.sizeThreshold = 300;
        this.initPolicies(this.rfa1, this.tbrp1, this.randomOutputDir + string + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}-%i.txt" + string3, this.sizeThreshold, this.currentTime, 0L);
        this.addExpectedFileName_ByFileIndexCounter(this.randomOutputDir, string, this.getMillisOfCurrentPeriodsStart(), this.fileIndexCounter, string3);
        this.incCurrentTime(100L);
        this.tbrp1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
        int n = 100;
        String string5 = "Hello -----------------";
        for (int i = 0; i < n; ++i) {
            String string6 = string5 + i;
            this.rfa1.doAppend((Object)string6);
            this.addExpectedFileNamedIfItsTime(this.randomOutputDir, string, string6, string3);
            this.incCurrentTime(20L);
            this.tbrp1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
            this.add(this.tbrp1.future);
        }
        if (bl) {
            this.secondPhase(string, string4, string2, string3, n, string5);
            n *= 2;
        }
        if (string2 != null) {
            this.massageExpectedFilesToCorresponToCurrentTarget(string4, true);
        }
        Thread.yield();
        this.waitForJobsToComplete();
        StatusPrinter.print((Context)this.context);
        SizeAndTimeBasedFNATP_Test.existenceCheck(this.expectedFilenameList);
        SizeAndTimeBasedFNATP_Test.sortedContentCheck(this.randomOutputDir, n, string5);
    }

    void secondPhase(String string, String string2, String string3, String string4, int n, String string5) {
        Object object;
        this.rfa1.stop();
        if (string3 != null) {
            object = new File(string2);
            ((File)object).setLastModified(this.currentTime);
        }
        object = this.context.getStatusManager();
        object.add((Status)new InfoStatus("Time when rfa1 is stopped: " + new Date(this.currentTime), (Object)this));
        object.add((Status)new InfoStatus("currentTime%1000=" + this.currentTime % 1000L, (Object)this));
        this.initRollingFileAppender(this.rfa2, string2);
        this.initPolicies(this.rfa2, this.tbrp2, this.randomOutputDir + string + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}-%i.txt" + string4, this.sizeThreshold, this.currentTime, 0L);
        for (int i = n; i < n * 2; ++i) {
            this.incCurrentTime(100L);
            this.tbrp2.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
            String string6 = string5 + i;
            this.rfa2.doAppend((Object)string6);
            this.addExpectedFileNamedIfItsTime(this.randomOutputDir, string, string6, string4);
        }
    }

    @Test
    public void noCompression_FileSet_NoRestart_1() throws InterruptedException, ExecutionException, IOException {
        this.generic("test1", "toto.log", false, DEFAULT_COMPRESSION_SUFFIX);
    }

    @Test
    public void noCompression_FileBlank_NoRestart_2() throws Exception {
        this.generic("test2", null, false, DEFAULT_COMPRESSION_SUFFIX);
    }

    @Test
    public void noCompression_FileBlank_WithStopStart_3() throws Exception {
        this.generic("test3", null, true, DEFAULT_COMPRESSION_SUFFIX);
    }

    @Test
    public void noCompression_FileSet_WithStopStart_4() throws Exception {
        this.generic("test4", "test4.log", true, DEFAULT_COMPRESSION_SUFFIX);
    }

    @Test
    public void withGZCompression_FileSet_NoRestart_5() throws Exception {
        this.generic("test5", "toto.log", false, ".gz");
    }

    @Test
    public void withGZCompression_FileBlank_NoRestart_6() throws Exception {
        this.generic("test6", null, false, ".gz");
    }

    @Test
    public void withZipCompression_FileSet_NoRestart_7() throws Exception {
        this.generic("test7", "toto.log", false, ".zip");
        List<String> list = this.filterElementsInListBySuffix(".zip");
        this.checkZipEntryMatchesZipFilename(list);
    }
}

