/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.ScaffoldingForRollingTests;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import java.io.IOException;
import java.util.List;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeBasedRollingTest
extends ScaffoldingForRollingTests {
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
    SizeBasedTriggeringPolicy<Object> sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
    EchoEncoder<Object> encoder = new EchoEncoder();

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.fwrp.setContext(this.context);
        this.fwrp.setParent(this.rfa);
        this.rfa.setContext(this.context);
        this.sizeBasedTriggeringPolicy.setContext(this.context);
    }

    private void initRFA(String string) {
        this.rfa.setEncoder(this.encoder);
        if (string != null) {
            this.rfa.setFile(string);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void activeFileNameNotSet() {
        this.sizeBasedTriggeringPolicy.setMaxFileSize("100");
        this.sizeBasedTriggeringPolicy.start();
        this.fwrp.setFileNamePattern("target/test-output/sizeBased-test1.%i");
        this.fwrp.start();
    }

    void generic(String string, String string2, String string3, List<String> list) throws InterruptedException, IOException {
        this.rfa.setName("ROLLING");
        this.initRFA(this.randomOutputDir + string2);
        this.sizeBasedTriggeringPolicy.setMaxFileSize("100");
        this.fwrp.setMinIndex(0);
        this.fwrp.setFileNamePattern(this.randomOutputDir + string3);
        this.rfa.triggeringPolicy = this.sizeBasedTriggeringPolicy;
        this.rfa.rollingPolicy = this.fwrp;
        this.fwrp.start();
        this.sizeBasedTriggeringPolicy.start();
        this.rfa.start();
        int n = 40;
        String string4 = "hello";
        for (int i = 0; i < n; ++i) {
            Thread.sleep(10L);
            this.rfa.doAppend((Object)(string4 + i));
        }
        this.rfa.stop();
        SizeBasedRollingTest.existenceCheck(list);
        SizeBasedRollingTest.reverseSortedContentCheck(this.randomOutputDir, n, string4);
    }

    @Test
    public void smoke() throws IOException, InterruptedException {
        this.expectedFilenameList.add(this.randomOutputDir + "a-sizeBased-smoke.log");
        this.expectedFilenameList.add(this.randomOutputDir + "sizeBased-smoke.0");
        this.expectedFilenameList.add(this.randomOutputDir + "sizeBased-smoke.1");
        this.generic("zipped", "a-sizeBased-smoke.log", "sizeBased-smoke.%i", this.expectedFilenameList);
    }

    @Test
    public void gz() throws IOException, InterruptedException {
        this.expectedFilenameList.add(this.randomOutputDir + "a-sbr-gzed.log");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-gzed.0.gz");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-gzed.1.gz");
        this.generic("gzed", "a-sbr-gzed.log", "sbr-gzed.%i.gz", this.expectedFilenameList);
    }

    @Test
    public void zipped() throws IOException, InterruptedException {
        this.expectedFilenameList.add(this.randomOutputDir + "a-sbr-zipped.log");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-zipped.0.zip");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-zipped.1.zip");
        this.generic("zipped", "a-sbr-zipped.log", "sbr-zipped.%i.zip", this.expectedFilenameList);
        List<String> list = this.filterElementsInListBySuffix(".zip");
        this.zipEntryNameCheck(list, "sbr-zipped.20\\d{2}-\\d{2}-\\d{2}_\\d{4}");
    }
}

