/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeBasedFileNamingAndTriggeringPolicyBaseTest {
    static long MILLIS_IN_MINUTE = 60000L;
    Context context = new ContextBase();
    RollingFileAppender rfa = new RollingFileAppender();
    TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
    DefaultTimeBasedFileNamingAndTriggeringPolicy timeBasedFNATP = new DefaultTimeBasedFileNamingAndTriggeringPolicy();

    @Before
    public void setUp() {
        this.rfa.setContext(this.context);
        this.tbrp.setContext(this.context);
        this.timeBasedFNATP.setContext(this.context);
        this.rfa.setRollingPolicy((RollingPolicy)this.tbrp);
        this.tbrp.setParent((FileAppender)this.rfa);
        this.tbrp.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)this.timeBasedFNATP);
        this.timeBasedFNATP.setTimeBasedRollingPolicy(this.tbrp);
    }

    @Test
    public void singleDate() {
        long l = 1324400341553L;
        this.tbrp.setFileNamePattern("foo-%d{yyyy-MM'T'mm}.log");
        this.tbrp.start();
        this.timeBasedFNATP.setCurrentTime(l);
        this.timeBasedFNATP.start();
        this.timeBasedFNATP.setCurrentTime(l + MILLIS_IN_MINUTE);
        this.timeBasedFNATP.isTriggeringEvent(null, null);
        String string = this.timeBasedFNATP.getElapsedPeriodsFileName();
        Assert.assertEquals((Object)"foo-2011-12T59.log", (Object)string);
    }

    @Test
    public void multiDate() {
        long l = 1324400341553L;
        this.tbrp.setFileNamePattern("foo-%d{yyyy-MM, AUX}/%d{mm}.log");
        this.tbrp.start();
        this.timeBasedFNATP.setCurrentTime(l);
        this.timeBasedFNATP.start();
        this.timeBasedFNATP.setCurrentTime(l + MILLIS_IN_MINUTE);
        this.timeBasedFNATP.isTriggeringEvent(null, null);
        String string = this.timeBasedFNATP.getElapsedPeriodsFileName();
        Assert.assertEquals((Object)"foo-2011-12/59.log", (Object)string);
    }
}

