/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.DefaultRolloverChecker;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RolloverChecker;
import ch.qos.logback.core.rolling.ScaffoldingForRollingTests;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.ZRolloverChecker;
import ch.qos.logback.core.testUtil.EnvUtilForTests;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedRollingTest
extends ScaffoldingForRollingTests {
    static final int NO_RESTART = 0;
    static final int WITH_RESTART = 1;
    static final int WITH_RESTART_AND_LONG_WAIT = 2000;
    static final boolean FILE_OPTION_SET = true;
    static final boolean FILE_OPTION_BLANK = false;
    RollingFileAppender<Object> rfa1 = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp1 = new TimeBasedRollingPolicy();
    RollingFileAppender<Object> rfa2 = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp2 = new TimeBasedRollingPolicy();
    EchoEncoder<Object> encoder = new EchoEncoder();
    RolloverChecker rolloverChecker;

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @After
    public void tearDown() {
    }

    void initRFA(RollingFileAppender<Object> rollingFileAppender, String string) {
        rollingFileAppender.setContext(this.context);
        rollingFileAppender.setEncoder(this.encoder);
        if (string != null) {
            rollingFileAppender.setFile(string);
        }
    }

    void initTRBP(RollingFileAppender<Object> rollingFileAppender, TimeBasedRollingPolicy<Object> timeBasedRollingPolicy, String string, long l) {
        timeBasedRollingPolicy.setContext(this.context);
        timeBasedRollingPolicy.setFileNamePattern(string);
        timeBasedRollingPolicy.setParent(rollingFileAppender);
        timeBasedRollingPolicy.timeBasedFileNamingAndTriggeringPolicy = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
        timeBasedRollingPolicy.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(l);
        rollingFileAppender.setRollingPolicy(timeBasedRollingPolicy);
        timeBasedRollingPolicy.start();
        rollingFileAppender.start();
    }

    void genericTest(String string, String string2, String string3, boolean bl, int n) throws IOException {
        String string4 = bl ? this.testId2FileName(string) : null;
        this.initRFA(this.rfa1, string4);
        String string5 = this.randomOutputDir + string2 + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}" + string3;
        this.initTRBP(this.rfa1, this.tbrp1, string5, this.currentTime);
        this.addExpectedFileName_ByDate(string5, this.getMillisOfCurrentPeriodsStart());
        this.incCurrentTime(1100L);
        this.tbrp1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
        for (int i = 0; i < 3; ++i) {
            this.rfa1.doAppend((Object)("Hello---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(string5);
            this.incCurrentTime(500L);
            this.tbrp1.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
            this.add(this.tbrp1.future);
        }
        this.rfa1.stop();
        this.waitForJobsToComplete();
        if (n != 0) {
            this.doRestart(string, string2, bl, n);
        }
        this.waitForJobsToComplete();
        this.massageExpectedFilesToCorresponToCurrentTarget(string4, bl);
        StatusPrinter.print((Context)this.context);
        this.rolloverChecker.check(this.expectedFilenameList);
    }

    void defaultTest(String string, String string2, String string3, boolean bl, int n) throws IOException {
        boolean bl2 = string3.length() > 0;
        this.rolloverChecker = new DefaultRolloverChecker(string, bl2, string3);
        this.genericTest(string, string2, string3, bl, n);
    }

    void doRestart(String string, String string2, boolean bl, int n) {
        File file = new File(this.rfa1.getFile());
        file.setLastModified(this.currentTime);
        this.incCurrentTime(n);
        String string3 = this.randomOutputDir + string2 + "-%d{" + "yyyy-MM-dd_HH_mm_ss" + "}";
        String string4 = bl ? this.testId2FileName(string) : null;
        this.initRFA(this.rfa2, string4);
        this.initTRBP(this.rfa2, this.tbrp2, string3, this.currentTime);
        for (int i = 0; i < 3; ++i) {
            this.rfa2.doAppend((Object)("World---" + i));
            this.addExpectedFileNamedIfItsTime_ByDate(string3);
            this.incCurrentTime(100L);
            this.tbrp2.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.currentTime);
            this.add(this.tbrp2.future);
        }
        this.rfa2.stop();
    }

    @Test
    public void noCompression_FileBlank_NoRestart_1() throws IOException {
        this.defaultTest("test1", "test1", "", false, 0);
    }

    @Test
    public void withCompression_FileBlank_NoRestart_2() throws IOException {
        this.defaultTest("test2", "test2", ".gz", false, 0);
    }

    @Test
    public void noCompression_FileBlank_StopRestart_3() throws IOException {
        this.defaultTest("test3", "test3", "", false, 1);
    }

    @Test
    public void noCompression_FileSet_StopRestart_4() throws IOException {
        this.defaultTest("test4", "test4", "", true, 1);
    }

    @Test
    public void noCompression_FileSet_StopRestart_WithLongWait_4B() throws IOException {
        this.defaultTest("test4B", "test4B", "", true, 2000);
    }

    @Test
    public void noCompression_FileSet_NoRestart_5() throws IOException {
        this.defaultTest("test5", "test6", "", true, 0);
    }

    @Test
    public void withCompression_FileSet_NoRestart_6() throws IOException {
        this.defaultTest("test6", "test6", ".gz", true, 0);
    }

    @Test
    public void withMissingTargetDirWithCompression() throws IOException {
        this.defaultTest("test7", "%d{yyyy-MM-dd, aux}/", ".gz", true, 0);
    }

    @Test
    public void withMissingTargetDirWithZipCompression() throws IOException {
        this.defaultTest("test8", "%d{yyyy-MM-dd, aux}/", ".zip", true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failed_rename() throws IOException {
        if (!EnvUtilForTests.isWindows()) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            String string = this.testId2FileName("failed_rename");
            File file = new File(string);
            file.getParentFile().mkdirs();
            fileOutputStream = new FileOutputStream(string);
            String string2 = "failed_rename";
            this.rolloverChecker = new ZRolloverChecker(string2);
            this.genericTest(string2, "failed_rename", "", true, 0);
        }
        finally {
            StatusPrinter.print((Context)this.context);
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

