/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.FileMatchFunction;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.ScaffoldingForRollingTests;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBasedRollingWithArchiveRemoval_Test
extends ScaffoldingForRollingTests {
    String MONTHLY_DATE_PATTERN = "yyyy-MM";
    String MONTHLY_CRONOLOG_DATE_PATTERN = "yyyy/MM";
    final String DAILY_CRONOLOG_DATE_PATTERN = "yyyy/MM/dd";
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    TimeBasedRollingPolicy<Object> tbrp = new TimeBasedRollingPolicy();
    TimeBasedFileNamingAndTriggeringPolicy<Object> tbfnatp = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
    long MILLIS_IN_MINUTE = 60000L;
    long MILLIS_IN_HOUR = 60L * this.MILLIS_IN_MINUTE;
    long MILLIS_IN_DAY = 24L * this.MILLIS_IN_HOUR;
    long MILLIS_IN_MONTH = (long)(30.43684991666667 * (double)this.MILLIS_IN_DAY);
    int MONTHS_IN_YEAR = 12;
    int slashCount = 0;
    boolean DO_CLEAN_HISTORY_ON_START = true;
    boolean DO_NOT_CLEAN_HISTORY_ON_START = false;

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    private int computeSlashCount(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '/') continue;
            ++n;
        }
        return n;
    }

    @Test
    public void monthlyRolloverOverManyPeriods() {
        this.slashCount = this.computeSlashCount(this.MONTHLY_CRONOLOG_DATE_PATTERN);
        int n = 40;
        int n2 = 2;
        String string = this.randomOutputDir + "/%d{" + this.MONTHLY_CRONOLOG_DATE_PATTERN + "}/clean.txt.zip";
        long l = this.currentTime;
        long l2 = this.logOverMultiplePeriodsContinuously(this.currentTime, string, this.MILLIS_IN_MONTH, n2, n);
        System.out.println("randomOutputDir:" + this.randomOutputDir);
        System.out.println("start:" + l + ", end=" + l2);
        int n3 = RollingCalendar.diffInMonths((long)l, (long)l2);
        System.out.println("differenceInMonths:" + n3);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n4 = calendar.get(2);
        boolean bl = this.extraFolder(n3, this.MONTHS_IN_YEAR, n4, n2);
        this.check(this.expectedCountWithFolders(n2, bl));
    }

    void generateDailyRollover(long l, int n, int n2, int n3, int n4) {
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        this.logOverMultiplePeriods(l, this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt", this.MILLIS_IN_DAY, n, n2, n3, n4);
        this.check(this.expectedCountWithoutFoldersWithInactivity(n, n2, n3 + n4));
    }

    @Test
    public void basicDailyRollover() {
        int n = 20;
        int n2 = 60;
        int n3 = 0;
        int n4 = 0;
        this.generateDailyRollover(this.currentTime, n, n2, n3, n4);
    }

    @Test
    public void dailyRollover15() {
        int n = 5;
        int n2 = 15;
        int n3 = 6;
        int n4 = 3;
        this.generateDailyRollover(this.currentTime, n, n2, n3, n4);
    }

    @Test
    public void dailyRolloverWithInactivity70() {
        int n = 6;
        int n2 = 70;
        int n3 = 30;
        int n4 = 1;
        this.generateDailyRollover(this.currentTime, n, n2, n3, n4);
    }

    @Test
    public void dailyRolloverWithInactivity10() {
        int n = 6;
        int n2 = 10;
        int n3 = 3;
        int n4 = 4;
        this.generateDailyRollover(this.currentTime, n, n2, n3, n4);
    }

    @Test
    public void dailyRolloverWithSecondPhase() {
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        int n = 5;
        long l = this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt", this.MILLIS_IN_DAY, n, n * 2);
        this.logOverMultiplePeriodsContinuously(l + this.MILLIS_IN_DAY * 10L, this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt", this.MILLIS_IN_DAY, n, n);
        this.check(this.expectedCountWithoutFolders(n));
    }

    @Test
    public void dailyCronologRollover() {
        this.slashCount = this.computeSlashCount("yyyy/MM/dd");
        this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "/%d{" + "yyyy/MM/dd" + "}/clean.txt.zip", this.MILLIS_IN_DAY, 8, 24);
        int n = 9 + this.slashCount;
        int n2 = n + 1 + 1;
        this.expectedFileAndDirCount(9, n, n2);
    }

    @Test
    public void dailySizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = this.computeSlashCount("yyyy-MM-dd");
        this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}-clean.%i.zip", this.MILLIS_IN_DAY, 5, 20);
        this.checkPatternCompliance(6 + this.slashCount, "\\d{4}-\\d{2}-\\d{2}-clean(\\.\\d)(.zip)?");
    }

    @Test
    public void dailyChronologSizeBasedRollover() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = 1;
        this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}/clean.%i.zip", this.MILLIS_IN_DAY, 5, 20);
        this.checkDirPatternCompliance(6);
    }

    @Test
    public void dailyChronologSizeBasedRolloverWithSecondPhase() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setMaxFileSize("10000");
        this.tbfnatp = sizeAndTimeBasedFNATP;
        this.slashCount = 1;
        int n = 5;
        int n2 = n * 4;
        long l = this.logOverMultiplePeriodsContinuously(this.currentTime, this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}/clean.%i", this.MILLIS_IN_DAY, n, 3);
        this.logOverMultiplePeriodsContinuously(l + this.MILLIS_IN_DAY * 7L, this.randomOutputDir + "/%d{" + "yyyy-MM-dd" + "}/clean.%i", this.MILLIS_IN_DAY, n, n2);
        this.checkDirPatternCompliance(n + 1);
    }

    void logOncePeriod(long l, String string, int n) {
        this.buildRollingFileAppender(l, string, n, this.DO_CLEAN_HISTORY_ON_START);
        this.rfa.doAppend((Object)("Hello ----------------------------------------------------------" + new Date(l)));
        this.rfa.stop();
    }

    @Test
    public void cleanHistoryOnStart() {
        long l = this.currentTime;
        String string = this.randomOutputDir + "clean-%d{" + "yyyy-MM-dd" + "}.txt";
        int n = 3;
        for (int i = 0; i <= 5; ++i) {
            this.logOncePeriod(l, string, n);
            l += this.MILLIS_IN_DAY;
        }
        StatusPrinter.print((Context)this.context);
        this.check(this.expectedCountWithoutFolders(n));
    }

    int expectedCountWithoutFolders(int n) {
        return n + 1;
    }

    int expectedCountWithFolders(int n, boolean bl) {
        int n2 = n + 1;
        int n3 = n2 * 2;
        int n4 = n3 + this.slashCount;
        if (bl) {
            ++n4;
        }
        return n4;
    }

    void buildRollingFileAppender(long l, String string, int n, boolean bl) {
        this.rfa.setContext(this.context);
        this.rfa.setEncoder((Encoder)this.encoder);
        this.tbrp.setContext(this.context);
        this.tbrp.setFileNamePattern(string);
        this.tbrp.setMaxHistory(n);
        this.tbrp.setParent(this.rfa);
        this.tbrp.setCleanHistoryOnStart(bl);
        this.tbrp.timeBasedFileNamingAndTriggeringPolicy = this.tbfnatp;
        this.tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(l);
        this.tbrp.start();
        this.rfa.setRollingPolicy(this.tbrp);
        this.rfa.start();
    }

    long logOverMultiplePeriodsContinuously(long l, String string, long l2, int n, int n2) {
        return this.logOverMultiplePeriods(l, string, l2, n, n2, 0, 0);
    }

    long logOverMultiplePeriods(long l, String string, long l2, int n, int n2, int n3, int n4) {
        this.buildRollingFileAppender(l, string, n, this.DO_NOT_CLEAN_HISTORY_ON_START);
        int n5 = 512;
        int n6 = n2 * n5;
        int n7 = 1 + n3 * n5;
        int n8 = n7 + n4 * n5;
        long l3 = l2 / (long)n5;
        for (int i = 0; i <= n6; ++i) {
            if (i < n7 || i > n8) {
                this.rfa.doAppend((Object)("Hello ----------------------------------------------------------" + i));
            }
            this.tbrp.timeBasedFileNamingAndTriggeringPolicy.setCurrentTime(this.addTime(this.tbrp.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime(), l3));
            this.add(this.tbrp.future);
            this.waitForJobsToComplete();
        }
        this.rfa.stop();
        return this.tbrp.timeBasedFileNamingAndTriggeringPolicy.getCurrentTime();
    }

    boolean extraFolder(int n, int n2, int n3, int n4) {
        int n5 = (n3 + n) % n2;
        return n5 < n4;
    }

    long addTime(long l, long l2) {
        return l + l2;
    }

    void expectedFileAndDirCount(int n, int n2, int n3) {
        File file = new File(this.randomOutputDir);
        ArrayList<File> arrayList = new ArrayList<File>();
        this.findFilesInFolderRecursivelyByPatterMatch(file, arrayList, "clean");
        ArrayList<File> arrayList2 = new ArrayList<File>();
        this.findAllFoldersInFolderRecursively(file, arrayList2);
        String string = "expectedDirCountMin=" + n2 + ", expectedDirCountMax=" + n3 + " actual value=" + arrayList2.size();
        Assert.assertTrue((String)string, (n2 <= arrayList2.size() && arrayList2.size() <= n3 ? 1 : 0) != 0);
    }

    void check(int n) {
        File file = new File(this.randomOutputDir);
        ArrayList<File> arrayList = new ArrayList<File>();
        this.findAllDirsOrStringContainsFilesRecursively(file, arrayList, "clean");
        Assert.assertEquals((long)n, (long)arrayList.size());
    }

    int expectedCountWithoutFoldersWithInactivity(int n, int n2, int n3) {
        int n4 = n2 + 1 - n3;
        int n5 = Math.min(n4, n + 1);
        return n5;
    }

    void genericFindMatching(final FileMatchFunction fileMatchFunction, File file, List<File> list, final String string, boolean bl) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || fileMatchFunction.match(file, string);
                }
            })) {
                if (file2.isDirectory()) {
                    if (bl) {
                        list.add(file2);
                    }
                    this.genericFindMatching(fileMatchFunction, file2, list, string, bl);
                    continue;
                }
                list.add(file2);
            }
        }
    }

    private void findAllFoldersInFolderRecursively(File file, List<File> list) {
        FileMatchFunction fileMatchFunction = new FileMatchFunction(){

            public boolean match(File file, String string) {
                return false;
            }
        };
        this.genericFindMatching(fileMatchFunction, file, list, null, true);
    }

    private void findAllDirsOrStringContainsFilesRecursively(File file, List<File> list, String string) {
        FileMatchFunction fileMatchFunction = new FileMatchFunction(){

            public boolean match(File file, String string) {
                return file.getName().contains(string);
            }
        };
        this.genericFindMatching(fileMatchFunction, file, list, string, true);
    }

    void findFilesInFolderRecursivelyByPatterMatch(File file, List<File> list, String string) {
        FileMatchFunction fileMatchFunction = new FileMatchFunction(){

            public boolean match(File file, String string) {
                return file.getName().matches(string);
            }
        };
        this.genericFindMatching(fileMatchFunction, file, list, string, false);
    }

    Set<String> groupByClass(List<File> list, String string) {
        Pattern pattern = Pattern.compile(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (File file : list) {
            String string2 = file.getName();
            Matcher matcher = pattern.matcher(string2);
            matcher.matches();
            int n = matcher.start(1);
            String string3 = string2.substring(0, n);
            hashSet.add(string3);
        }
        return hashSet;
    }

    void checkPatternCompliance(int n, String string) {
        File file = new File(this.randomOutputDir);
        ArrayList<File> arrayList = new ArrayList<File>();
        this.findFilesInFolderRecursivelyByPatterMatch(file, arrayList, string);
        Set<String> set = this.groupByClass(arrayList, string);
        Assert.assertEquals((long)n, (long)set.size());
    }

    void checkDirPatternCompliance(int n) {
        File file = new File(this.randomOutputDir);
        ArrayList<File> arrayList = new ArrayList<File>();
        this.findAllFoldersInFolderRecursively(file, arrayList);
        for (File file2 : arrayList) {
            Assert.assertTrue((file2.list().length >= 1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)n, (long)arrayList.size());
    }
}

