/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompressTest {
    Context context = new ContextBase();

    @Before
    public void setUp() throws IOException {
        File file = new File("src/test/input/compress1.copy");
        File file2 = new File("src/test/input/compress1.txt");
        this.copy(file, file2);
        File file3 = new File("target/test-output/compress1.txt.gz");
        file3.mkdirs();
        file3.delete();
        file = new File("src/test/input/compress2.copy");
        file2 = new File("src/test/input/compress2.txt");
        this.copy(file, file2);
        file3 = new File("target/test-output/compress2.txt.gz");
        file3.mkdirs();
        file3.delete();
        file = new File("src/test/input/compress3.copy");
        file2 = new File("src/test/input/compress3.txt");
        this.copy(file, file2);
        file3 = new File("target/test-output/compress3.txt.zip");
        file3.mkdirs();
        file3.delete();
    }

    @Test
    public void test1() throws Exception {
        Compressor compressor = new Compressor(CompressionMode.GZ);
        compressor.setContext(this.context);
        compressor.compress("src/test/input/compress1.txt", "target/test-output/compress1.txt.gz", null);
        StatusChecker statusChecker = new StatusChecker(this.context);
        Assert.assertTrue((boolean)statusChecker.isErrorFree(0L));
        Assert.assertTrue((boolean)Compare.gzCompare("target/test-output/compress1.txt.gz", "src/test/witness/compress1.txt.gz"));
    }

    @Test
    public void test2() throws Exception {
        Compressor compressor = new Compressor(CompressionMode.GZ);
        compressor.setContext(this.context);
        compressor.compress("src/test/input/compress2.txt", "target/test-output/compress2.txt", null);
        StatusChecker statusChecker = new StatusChecker(this.context);
        Assert.assertTrue((boolean)statusChecker.isErrorFree(0L));
        Assert.assertTrue((boolean)Compare.gzCompare("target/test-output/compress2.txt.gz", "src/test/witness/compress2.txt.gz"));
    }

    @Test
    public void test3() throws Exception {
        Compressor compressor = new Compressor(CompressionMode.ZIP);
        compressor.setContext(this.context);
        compressor.compress("src/test/input/compress3.txt", "target/test-output/compress3.txt", "compress3.txt");
        StatusChecker statusChecker = new StatusChecker(this.context);
        Assert.assertTrue((boolean)statusChecker.isErrorFree(0L));
    }

    private void copy(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }
}

