/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import java.util.Calendar;
import junit.framework.Assert;
import org.junit.Test;

public class FileNamePatternTest {
    Context context = new ContextBase();

    @Test
    public void testSmoke() {
        FileNamePattern fileNamePattern = new FileNamePattern("t", this.context);
        Assert.assertEquals((String)"t", (String)fileNamePattern.convertInt(3));
        fileNamePattern = new FileNamePattern("foo", this.context);
        Assert.assertEquals((String)"foo", (String)fileNamePattern.convertInt(3));
        fileNamePattern = new FileNamePattern("%i foo", this.context);
        Assert.assertEquals((String)"3 foo", (String)fileNamePattern.convertInt(3));
        fileNamePattern = new FileNamePattern("foo%i.xixo", this.context);
        Assert.assertEquals((String)"foo3.xixo", (String)fileNamePattern.convertInt(3));
        fileNamePattern = new FileNamePattern("foo%i.log", this.context);
        Assert.assertEquals((String)"foo3.log", (String)fileNamePattern.convertInt(3));
        fileNamePattern = new FileNamePattern("foo.%i.log", this.context);
        Assert.assertEquals((String)"foo.3.log", (String)fileNamePattern.convertInt(3));
    }

    @Test
    public void flowingI() {
        FileNamePattern fileNamePattern = new FileNamePattern("foo%i{}bar%i", this.context);
        Assert.assertEquals((String)"foo3bar3", (String)fileNamePattern.convertInt(3));
        fileNamePattern = new FileNamePattern("foo%i{}bar%i", this.context);
        Assert.assertEquals((String)"foo3bar3", (String)fileNamePattern.convertInt(3));
    }

    @Test
    public void date() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2003, 4, 20, 17, 55);
        FileNamePattern fileNamePattern = new FileNamePattern("foo%d{yyyy.MM.dd}", this.context);
        Assert.assertEquals((String)"foo2003.05.20", (String)fileNamePattern.convert((Object)calendar.getTime()));
        fileNamePattern = new FileNamePattern("foo%d{yyyy.MM.dd HH:mm}", this.context);
        Assert.assertEquals((String)"foo2003.05.20 17:55", (String)fileNamePattern.convert((Object)calendar.getTime()));
        fileNamePattern = new FileNamePattern("%d{yyyy.MM.dd HH:mm} foo", this.context);
        Assert.assertEquals((String)"2003.05.20 17:55 foo", (String)fileNamePattern.convert((Object)calendar.getTime()));
    }

    @Test
    public void withBackslash() {
        FileNamePattern fileNamePattern = new FileNamePattern("c:\\foo\\bar.%i", this.context);
        Assert.assertEquals((String)"c:/foo/bar.3", (String)fileNamePattern.convertInt(3));
    }

    @Test
    public void objectListConverter() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2003, 4, 20, 17, 55);
        FileNamePattern fileNamePattern = new FileNamePattern("foo-%d{yyyy.MM.dd}-%i.txt", this.context);
        Assert.assertEquals((String)"foo-2003.05.20-79.txt", (String)fileNamePattern.convertMultipleArguments(new Object[]{calendar.getTime(), 79}));
    }

    @Test
    public void asRegexByDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2003, 4, 20, 17, 55);
        FileNamePattern fileNamePattern = new FileNamePattern("foo-%d{yyyy.MM.dd}-%i.txt", this.context);
        String string = fileNamePattern.toRegexForFixedDate(calendar.getTime());
        Assert.assertEquals((String)"foo-2003.05.20-(\\d{1,3}).txt", (String)string);
        fileNamePattern = new FileNamePattern("\\toto\\foo-%d{yyyy\\MM\\dd}-%i.txt", this.context);
        string = fileNamePattern.toRegexForFixedDate(calendar.getTime());
        Assert.assertEquals((String)"/toto/foo-2003/05/20-(\\d{1,3}).txt", (String)string);
    }

    @Test
    public void asRegex() {
        FileNamePattern fileNamePattern = new FileNamePattern("foo-%d{yyyy.MM.dd}-%i.txt", this.context);
        String string = fileNamePattern.toRegex();
        Assert.assertEquals((String)"foo-\\d{4}\\.\\d{2}\\.\\d{2}-\\d{1,2}.txt", (String)string);
        fileNamePattern = new FileNamePattern("foo-%d{yyyy.MM.dd'T'}-%i.txt", this.context);
        string = fileNamePattern.toRegex();
        Assert.assertEquals((String)"foo-\\d{4}\\.\\d{2}\\.\\d{2}T-\\d{1,2}.txt", (String)string);
    }

    @Test
    public void convertMultipleDates() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2003, 4, 20, 17, 55);
        FileNamePattern fileNamePattern = new FileNamePattern("foo-%d{yyyy.MM, aux}/%d{yyyy.MM.dd}.txt", this.context);
        Assert.assertEquals((String)"foo-2003.05/2003.05.20.txt", (String)fileNamePattern.convert((Object)calendar.getTime()));
    }
}

